/*  Emacs mode: -*- C++ -*-  */

/*  "Aqua_Surface" with Phillips spectrum  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_SURFACE_PHILLIPS_H
#define _AQUA_SURFACE_PHILLIPS_H


/****************  includes  ****************/


#include "aqua_surface.h"


/****************  classes  ****************/


class Aqua_Surface_Phillips : public Aqua_Surface
{
 public:

  /*  creates a surface and sets it at time 0.0  */
  Aqua_Surface_Phillips(int points_x,      /* numbers of discrete sample...   */
			int points_z,      /* ...points, must be power of two */
			float size_x,               /*  meters  */
			float size_z,               /*  meters  */
			float depth,   /* of water, meters, 0.0 means infinite*/
			float displacement_factor,  /*  horizontal  */
			float spectrum_factor,
			float smallest_wave,        /*  meters  */
			float wind_speed,
			float wind_angle,
			class Aqua_Rng *rng,
			float loop_time = 0.0); /* seconds (0.0 means no loop)*/

  ~Aqua_Surface_Phillips(void);


  /****  set  ****/

  void set_spectrum_factor(float spectrum_factor);
  void set_smallest_wave(float smallest_wave);      /*  meters   */
  void set_wind_speed(float wind_speed);            /*  m.s^-1   */
  void set_wind_angle(float wind_angle);            /*  radians  */


  /****  get  ****/

  float get_spectrum_factor(void) const;  
  float get_smallest_wave(void) const;  
  float get_wind_speed(void) const;
  float get_largest_wave(void) const;  
  float get_wind_angle(void) const;
  /*  fills two elements vector "wind_vector"  */
  void get_wind_vector(float *wind_vector) const;


 protected:

  class Aqua_Wave_Spectrum_Context_Phillips *spectrum_context;
  /*  temporary object, used to initialize the base class  */
  class Aqua_Wave_Factory_Phillips *wave_factory;

  /*  copy constructor to be defined  */
  Aqua_Surface_Phillips(const class Aqua_Surface_Phillips &);
};


#endif  /*  _AQUA_SURFACE_PHILLIPS_H  */
