/*  Begin aqua_surface_ugaussian.cpp  */

/*  "Aqua_Surface" with unit gaussian distribution  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "aqua_surface_ugaussian.h"

#include "aqua_rng_ugaussian.h"
#include "aqua_wave.h"


/****************  public functions  ****************/


Aqua_Surface_Ugaussian::
Aqua_Surface_Ugaussian(int points_x,
		       int points_z,
		       float size_x,
		       float size_z,
		       float depth,
		       float displacement_factor,
		       class Aqua_Wave_Factory *wave_factory,
		       class Aqua_Wave_Spectrum_Context *spectrum_context,
		       float loop_time)
  : Aqua_Surface(points_x,
		 points_z,
		 size_x,
		 size_z,
		 depth,
		 displacement_factor,
		 wave_factory,
		 spectrum_context,
		 this->rng = new class Aqua_Rng_Ugaussian(),
		 loop_time)
{
  delete this->rng;
}


/*  End aqua_surface_ugaussian.cpp  */
