/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_WAVE_H
#define _AQUA_WAVE_H


/****************  abstract classes  ****************/


class Aqua_Wave_Factory
{
 public:

  virtual ~Aqua_Wave_Factory(void) = 0;


  virtual class Aqua_Wave *create(void) = 0;
};


class Aqua_Wave_Spectrum_Context
{
 public:

  virtual ~Aqua_Wave_Spectrum_Context(void) = 0;
};


class Aqua_Wave
{
 public:

  virtual ~Aqua_Wave(void) = 0;


  /*  inits the wave and sets magnitude_[xz] and unit_vector_[xz]  */
  virtual void init(float &magnitude_x,      /* vector magnitude */
		    float &magnitude_z,
		    float &unit_vector_x,    /* normalized vector magnitude */
		    float &unit_vector_z,
		    int vector_x,       /* vector X coordinate, [ -N/2, N/2 [ */
		    int vector_z,       /* vector Z coordinate, [ -M/2, M/2 [ */
		    float size_x,      /* size_x of the whole surface, meters */
		    float size_z,      /* size_z of the whole surface, meters */
		    float random_real,       /*  random number  */
		    float random_imaginary,  /*  random number  */
		    float depth,  /* water depth, meters (0.0 means infinite) */
		    float basic_frequency,   /*  s-1, 0.0 means no loop  */
		    class Aqua_Wave_Spectrum_Context *spectrum_context);


  /****  set  ****/

  /*
    if depth == 0.0 (infinite depth) or basic_frequency == 0.0 (no loop),
    doesn't take them into account
  */
  void set_frequency(float depth, float basic_frequency);
  void set_spectrum(class Aqua_Wave_Spectrum_Context *context);
  virtual float compute_spectrum(class Aqua_Wave_Spectrum_Context *context)= 0;


  /****  get  ****/

  /*  returns the fourier_amplitude of the wave at time "time" (in second)  */  
  float get_fourier_amplitude(float time) const;


 protected:

  float magnitude;         /*  vector magnitude  */
  float length;            /*  length of the wave, in meters  */
  float random_real;       /*  random number  */
  float random_imaginary;  /*  random number  */
  float frequency;         /*  s-1  */
  float spectrum;
};


#endif  /*  _AQUA_WAVE_H  */
