/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef FIELD_H
#define FIELD_H


/****************  functions  ****************/


/****  allocation  ****/

/*  returns a pointer to an array of "points_x" * "points_z" elements  */
extern float **field_allocate_2d(int points_x, int points_z);

/*
  returns a pointer to an array of 3 * ("points_x" + 1) * ("points_z" + 1)
  elements
*/
extern float ***field_allocate_3d(int points_x, int points_z);


/****  free  ****/

/*  frees "field" allocated with "field_allocate_2d()" and "points_x"  */
extern void field_free_2d(int points_x, float **field);

/*  frees "field" allocated with "field_allocate_3d()" and "points_x"  */
extern void field_free_3d(int points_x, float ***field);


/****  compute fields  ****/

/*
  fills "field_surface" from "field_fourier_amplitudes",
  "field_waves_unit_vector_[xz]" and displacement_factor, using "fft"
*/
extern void field_heights_compute(float **field_fourier_amplitudes,
				  float **field_heights,
				  class Aqua_Fft *fft);

extern void field_position_x_compute(float resolution_x,
				     float displacement_factor,
				     float **field_fourier_amplitudes,
				     float **field_waves_unit_vector_x,
				     float **field_position_x,
				     class Aqua_Fft *fft);
extern void field_position_z_compute(float resolution_z,
				     float displacement_factor,
				     float **field_fourier_amplitudes,
				     float **field_waves_unit_vector_z,
				     float **field_position_z,
				     class Aqua_Fft *fft);
/*
  fills "field_normals" from "field_fourier_amplitudes" and
  "field_waves_magnitudes_[xz], using "fft"
*/
extern void field_normals_compute(float **field_fourier_amplitudes,
				  float **field_waves_magnitudes_x,
				  float **field_waves_magnitudes_z,
				  float ***field_normals,
				  class Aqua_Fft *fft);


#endif  /*  FIELD_H  */
