/*  Begin vector.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "vector.h"

/*  C lib  */
extern "C"
{
#include <math.h>
}


/****************  static functions prototypes  ****************/


namespace
{
  void normalize(float *vector, int elements, float length);
  float length_3d(float *vector);
}


/****************  functions  ****************/


/*
  returns the scalar product of "vector1" by "vector2", of size "vectors_size"
*/
float
vector_scalar_product(int vectors_size, float *vector1, float *vector2)
{
  float product;
  int i;

  product = 0;

  for (i = 0; i < vectors_size; i++)
    {
      product += vector1[i] * vector2[i];
    }

  return product;
}


/*  normalizes two elements vector "vector"  */
void
vector_normalize_2d(float *vector)
{
  float length;

  length = hypotf(vector[0], vector[1]);

  normalize(vector, 2, length);
}


/*  normalizes three elements vector "vector"  */
void
vector_normalize_3d(float *vector)
{
  float length;

  length = length_3d(vector);

  normalize(vector, 3, length);
}


/****************  static functions  ****************/


namespace
{


void
normalize(float *vector, int elements, float length)
{
  int i;

  if (isnormal(length) != 0)
    {
      for (i = 0; i < elements; i++)
	{
	  vector[i] /= length;
	}
    }
}


float
length_3d(float *vector)
{
  float length;
  int i;

  length = 0;

  for (i = 0; i < 3; i++)
    {
      /*  TIME CRITICAL: don't use powf() here  */
      length += vector[i] * vector[i];
    }

  return sqrtf(length);
}


}  /*  namespace  */


/*  End vector.cpp  */
