<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";


include_once ('inc/evt_initiate.inc.php');


// SETUP FILE ------------------------------------------------------------
require_once ('components/core/class/File.class.php');
$file = new File($db, $core_config['file']);
$file->module_id = 0; // core
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file = $file;

// Wiki setup
require_once ('components/core/class/Wiki/Wiki.php');
require_once ('components/core/class/Wiki/Wiki/Parse.php');
require_once ('components/core/class/Wiki/Wiki/Render.php');
$wiki = new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', "get_file.php?file=");



// SETUP PARTICIPATION ---------------------------------------------------
require_once ('components/core/class/Participation.class.php');
$participation = new Participation($db, $core_config);
$participation->module_id = $core_config['module_id']['event'];
$participation->item_id = $_REQUEST['event_id'];



// SETUP EVENT -----------------------------------------------------------
// require_once ('config/evt.config.php');
// require_once ('class/Event.class.php');
// $event = new Event($db, $core_config);
// $event->date = new Date;
// $event->single_event = true;
// $event->event_config = $event_config;
// $event->event_id = $_REQUEST['event_id'];
// $event->allEvents();
// $event->wiki = $wiki;



// We take care of $_POSTS -----------------------------------------------
if (isset($_POST['frm_send'])) {

	// We need to check here if the event is full
	// Only if it is not, we allow people to sign up
	
	$query = "
		SELECT COUNT(*) AS total, e.event_allocation 
		FROM " . $db->prefix . "_participation p 
		LEFT join " . $db->prefix . "_event e 
		ON e.event_id=p.item_id 
		WHERE p.module_id=" . $core_config['module_id']['event'] . " 
		AND p.item_id=" . $event->event_id . " AND p.status_id=" . $event_config['user']['status']['active'] . " 
		GROUP BY item_id"
	;

	$result = $db->Execute($query);
	if (isset($result->fields)) {
		if ($result->fields['total'] == $result->fields['event_allocation']) { // We cannot apply to a full event
			header('location: index.php?amn=evt_item&event_id=' . $event->event_id);
			$result->Close();
			exit;
		}
		$result->Close();
	}



	// we need the event we are looking at
	$temp = $event->selEvent();
	
	$data = array();
	$data['module_id'] = $core_config['module_id']['event'];
	$data['item_id'] = $event->event_id;
	$data['user_id'] = $_SESSION['user_id'];
	
	switch($temp['event_type']) {
		case $event_config['type']['approved']: {
			$data['status_id'] = $event_config['user']['status']['pending'];
		}
		break;
		default: {
			$data['status_id'] = $event_config['user']['status']['active'];
		}
		break;
	}
	
	$data['identity_id'] = $_POST['activity_identity'];
	$data['participation_permission'] = $temp['default_user_permission'];
	
	$participation->insertParticipant($data);
}
elseif (isset($_POST['frm_invitation'])) {

	$temp = $event->selEvent();

	$query = "
		SELECT user_id, identity_id, role_id, status_id, 
		participation_permission 
		FROM " . $db->prefix . "_participation 
		WHERE 
		item_id=" . $temp['event_id'] . " AND 
		module_id=" . $core_config['module_id']['event'] . " AND 
		user_id=" . $_SESSION['user_id']
	;
		
	$result = $db->Execute($query);
			
	if (isset($result->fields)) {
		$rec = array();
		$rec['identity_id'] = $_POST['activity_identity'];
		$rec['status_id'] = $event_config['user']['status']['active'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		header("Location: index.php?amn=evt_item&event_id=" . $temp['event_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['frm_widthdraw'])) {

	// We delete all relations we have within this item & module_id
	// We delete our participation and sends us back to the item
	
	$query = "
		DELETE FROM " . $db->prefix . "_relation
		WHERE item_id=" . $_REQUEST['event_id'] . " AND 
		module_id=" . $core_config['module_id']['event'] . " AND 
		user_id=" . $_SESSION['user_id'] . " AND 
		1=1"
	;
	//First we delete all relations we have in the module and item
	$db->Execute($query);
	
	$query = "
		DELETE FROM " . $db->prefix . "_participation
		WHERE item_id=" . $_REQUEST['event_id'] . " AND 
		module_id=" . $core_config['module_id']['event'] . " AND 
		user_id=" . $_SESSION['user_id'] . " AND 
		1=1"
	;
	// Then we delete our participation from this module and item
	$db->Execute($query);
	
	header('location: index.php?amn=evt_item&event_id=' . $event->event_id);
	exit;
}
elseif (isset($_POST['frm_select_participants'])) {

	$output_participation = $participation->selParticipation($_SESSION['user_id']);

	// We delete all relations that is not checked
	$query = "
		DELETE FROM " . $db->prefix . "_relation
		WHERE identity_id=" . $output_participation['identity_id'] . " AND 
		module_id=" . $core_config['module_id']['event'] . " AND 
		item_id=" . $_REQUEST['event_id'] . " AND 
		identity_id_relation IN (" . implode(', ', $_POST['frm_participants_hidden']) . ")"
	;
	$db->Execute($query);


	// We "move" persons from one list to the other
	// that is, we are creating a one-way strong relationship
	// with them


	$data = array();
	$data['module_id'] = $core_config['module_id']['event'];
	$data['item_id'] = $_REQUEST['event_id'];
	$data['identity_id'] = $output_participation['identity_id'];
	$data['identity_id_relation'] = 0;
	$data['relation_create_datetime'] = time();
	$data['relation_portable'] = 'null';
	$data['user_id'] = $_SESSION['user_id'];

	$table = $db->prefix . "_relation";
	
	if (isset($_POST['frm_participants']) && !empty($_POST['frm_participants'])) {
		foreach($_POST['frm_participants'] as $p) {
			$data['identity_id_relation'] = $p;
			$query = $db->GetInsertSQL($table, $data, get_magic_quotes_gpc());
			$db->Execute($query);
		}
	}
}
elseif (isset($_POST['frm_remove']) && !empty($_POST['frm_delete_participants'])) {
	
	// We dont want to have this persons in our
	// meeting-list, therefore we remove them
	// That is, we delete our relation with them
	
	
	$output_participation = $participation->selParticipation($_SESSION['user_id']);
	
	$query = "
		DELETE FROM " . $db->prefix . "_relation
		WHERE module_id=" . $core_config['module_id']['event'] . " AND
		item_id=" . $_REQUEST['event_id'] . " AND
		identity_id=" . $output_participation['identity_id'] . " AND
		identity_id_relation IN (" . implode(', ', $_POST['frm_delete_participants']) . ") AND 
		1=1"
	; 
	$db->Execute($query);
}
elseif (isset($_POST['frm_add_inbound_relations'])) {
	$output_participation = $participation->selParticipation($_SESSION['user_id']);
	
	$data = array();
	$data['module_id'] = $core_config['module_id']['event'];
	$data['item_id'] = $_REQUEST['event_id'];
	$data['identity_id'] = $output_participation['identity_id'];
	$data['identity_id_relation'] = 0;
	$data['relation_create_datetime'] = time();
	$data['relation_portable'] = 'null';
	$data['user_id'] = $_SESSION['user_id'];

	$table = $db->prefix . "_relation";
	
	foreach($_POST['frm_inbound_relations'] as $p) {
		$data['identity_id_relation'] = $p;
		$query = $db->GetInsertSQL($table, $data, get_magic_quotes_gpc());
		$db->Execute($query);
	}
}
elseif (isset($_POST['frm_pending']) && !empty($_POST['frm_participants'])) {
	// Set persons to pending
	$participation->setUserStatus($_POST['frm_participants'], $event_config['user']['status']['pending']);
}
elseif (isset($_POST['frm_active']) && !empty($_POST['frm_participants'])) {
	// Set persons to active
	$participation->setUserStatus($_POST['frm_participants'], $event_config['user']['status']['active']);
}
elseif (isset($_POST['frm_barred']) && !empty($_POST['frm_participants'])) {
	// Set persons to barred
	$participation->setUserStatus($_POST['frm_participants'], $event_config['user']['status']['barred']);
}
elseif (isset($_POST['update_participant'])) {
	$query = "
		SELECT *
		FROM " . $db->prefix . "_participation 
		WHERE module_id=" . $core_config['module_id']['event'] . " AND
		item_id=" . $_REQUEST['event_id'] . " AND 
		identity_id=" . $_REQUEST['identity_id'] . " AND 
		1=1"
	;
	
	$result = $db->Execute($query);
	$rec    = array();
	if (isset($_POST['status_id']) && !empty($_POST['status_id'])) {
		$rec['status_id'] = $_POST['status_id'];
	}
	
	if (isset($_POST['coordinator'])) {
		if (!empty($_POST['coordinator'])) {
			$rec['role_id'] = 1;
		}
		else {
			$rec['role_id'] = 0;
		}
	}
	
	$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
	$db->Execute($query);
}

// Selecting some stuff from the database ------------------------------------
$output_participation = $participation->selParticipation($_SESSION['user_id']);
$output_event = $event->selEvents(false, false);
$output_identities = $user->selUserIdentities($_SESSION['user_id']);

// Added 061207
if (empty($output_participation) && $output_event['event_type'] == $event_config['type']['invitation']) {
	header('location: index.php?amn=evt_item&event_id=' . $event->event_id);
	exit;
}

// INVITATION
if (isset($output_participation) && $output_participation['status_id'] == $event_config['user']['status']['invite']) {
	$body->set('invite', 1);
	// get user identities for join dropdown
	$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
	$body->set('identities', $output_identities);
	
	if (!empty($output_participation['invitee_user_id'])) {
		$output_invitee = $user->selUserIdentity($output_participation['invitee_user_id']);
		$body->set('invitee_identity', $output_invitee);
	}
}

if (!empty($output_participation)) {



	// if we check at a participant ----------------------------------
	if (isset($_REQUEST['identity_id']) && is_numeric($_REQUEST['identity_id'])) {
		$user->file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$user->file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
		$output_participant['identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id']);
		$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
		$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	}
	// ---------------------------------------------------------------

	// am I the owner of the event? ----------------------------------
	$output_participation['owner'] = $_SESSION['user_id'] == $output_event['user_id'];
	// ---------------------------------------------------------------
	
	// summary of participants ---------------------------------------
	if ($output_participation['owner'] || $output_participation['role_id']) {
		foreach($event_config['user']['status'] as $key => $i) {
			$output_summary['status'][$i] = $participation->countParticipants($i);
		}
		$output_summary['relations'] = $participation->countParticipants();
		$output_summary['coordinators'] = $participation->countParticipants(null, $event_config['role']['coordinator']);
	}
	// ---------------------------------------------------------------

	// selecting participants ----------------------------------------
	$query = "
		SELECT p.identity_id, p.participation_create_datetime, p.user_id
		FROM " . $db->prefix . "_participation p
		WHERE p.module_id=" .$core_config['module_id']['event']. " AND 
		p.item_id=" . $_REQUEST['event_id'] . " AND 
		1=1 AND p.status_id=" . $event_config['user']['status']['active'] . ""
	;
	
// 	if (isset($_REQUEST['status_id']) && !empty($_REQUEST['status_id'])) {
// 		$query .= " AND p.status_id=" . $_REQUEST['status_id'] . " AND 1=1";
// 	}
	
// 	elseif (isset($_REQUEST['list']) && $_REQUEST['list'] == 'coordinators') {
// 		$query .= " AND p.role_id=" . $event_config['role']['coordinator'] . " AND 1=1";
// 	}
	
	$query .= " ORDER BY p.participation_create_datetime DESC";

	$output_participants = array();
	$result = $db->Execute($query);
	while(!$result->EOF) {
		array_push($output_participants, $result->fields);
		$result->moveNext();
	}
	$result->Close();
	//EO selecting participants --------------------------------------
	
	// strong outbound relations --------------------------------------
	$query = "
		SELECT r.identity_id_relation AS identity_id, r.relation_create_datetime
		FROM " . $db->prefix . "_relation r
		WHERE r.identity_id=" . $output_participation['identity_id'] . " AND
		r.module_id= " . $core_config['module_id']['event'] . " AND
		r.item_id= " . $_REQUEST['event_id'] . " AND
		1=1"
	;

	$output_strong_outbound_relations = array();
	$result = $db->Execute($query);
	while(!$result->EOF) {
		array_push($output_strong_outbound_relations, $result->fields);
		$result->moveNext();
	}
	$result->Close();
	//EO strong outbound relations ------------------------------------
	
	// strong inbound relations ---------------------------------------
	$query = "
		SELECT r.identity_id, r.relation_create_datetime
		FROM " . $db->prefix . "_relation r
		WHERE r.identity_id_relation=" . $output_participation['identity_id'] . " AND
		r.module_id=" . $core_config['module_id']['event'] . " AND
		r.item_id=" . $_REQUEST['event_id'] . " AND
		1=1"
	;
	
	$output_strong_inbound_relations = array();
	$result = $db->Execute($query);
	while(!$result->EOF) {
		array_push($output_strong_inbound_relations, $result->fields);
		$result->moveNext();
	}
	$result->Close();
	//EO strong inbound relations -------------------------------------
	
	$output_strong_outbound_relations_diff = array();
	foreach($output_strong_inbound_relations as $p) {
		$e = false;
		foreach($output_strong_outbound_relations as $r) {
			if ($r['identity_id'] == $p['identity_id']) {
				$e = !$e;
			}
		}
		if (!$e) {
			array_push($output_strong_outbound_relations_diff, $p);
		}
	}


	foreach($output_participants as $key => $p) {
		$output_participants[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id']);
		foreach($output_strong_outbound_relations as $r) {
			if ($p['identity_id'] == $r['identity_id']) {
				$output_participants[$key]['mutual'] = true;
			}
		}
	}

	foreach($output_strong_outbound_relations as $key => $p) {
		$output_strong_outbound_relations[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id']);

		foreach($output_strong_inbound_relations as $r) {
			if ($p['identity_id'] == $r['identity_id']) {
				$output_strong_outbound_relations[$key]['mutual'] = true;
				$output_strong_outbound_relations[$key]['relation_create_datetime'] = $r['relation_create_datetime'];
			}
		}
	}
	
	foreach($output_strong_outbound_relations_diff as $key => $p) {
		$output_strong_outbound_relations_diff[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id']);
	}
}




// Sending some stuff to the browser -----------------------------------------
if (empty($output_participation)) {
	$body->set('join', true);
}
else {
	if ($event_config['resource']['user']['manage_participants'] & $output_participation['participation_permission']) {
		$body->set('manage_access', 1);
	}
}

if (!empty($output_participation['owner'])) {
	$body->set('owner', true);
}

if (isset($_REQUEST['status_id']) && !empty($_REQUEST['status_id'])) {
	$body->set('status_screen', $_REQUEST['status_id']);
}

if (isset($_REQUEST['list']) && !empty($_REQUEST['list'])) {
	$body->set('list_screen', true);
}

if (isset($output_participant) && !empty($output_participant)) {
	$body->set('participant', $output_participant);
}

if (!empty($output_participation['role_id'])) {
	$body->set('coordinator', true);
}

if (!empty($output_event)) {
	$body->set('event', $output_event);
}

if (!empty($output_identities)) {
	$body->set('identities', $output_identities);
}

if (!empty($output_participants)) {
	$body->set('participants', $output_participants);
}

if (!empty($output_strong_outbound_relations)) {
	$body->set('outbound_relations', $output_strong_outbound_relations);
}

if (!empty($output_strong_outbound_relations_diff)) {
	$body->set('inbound_relations', $output_strong_outbound_relations_diff);
}

if (!empty($output_summary)) {
	$body->set('summary', $output_summary);
}


?>