<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<style type="text/css">
<!--
@import url(<?php echo $template_path_core;?>css/aroundme_form.css);
@import url(<?php echo $template_path_core;?>css/aroundme_calendar.css);
-->
</style>

<script type="text/javascript" src="<?php echo $template_path_core;?>js/calendar.js"></script>
<script type="text/javascript" src="<?php echo $template_path_core;?>js/calendar-setup.js"></script>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_events']; ?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table cellspacing="0" cellpadding="2" border="0">
				<?php if (isset($events)) { 
				foreach($events as $e): ?>
					<tr>
						<td width="35" rowspan="3">
							<img src="get_file.php?file=<?php if (isset($e['file']['file_md5_name_view'])) echo $e['file']['file_md5_name_view']; ?>" />
						</td>
						<td valign="top" colspan="2">
							<b><a href="index.php?amn=evt_item&amp;event_id=<?php echo $e['event_id']; ?>"><?php echo $this->date->formatDate($e['event_start_datetime'], 4);?></a>: <?php echo $e['event_title']; ?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<?php echo $e['event_synopsis']; ?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $this->date->formatDate($e['event_start_datetime']); ?>
						</td>
						<td valign="top">
						<?php echo $lang['txt_latst']; ?>
						<?php if ($e['event_duration'] < 24) { echo $e['event_duration']; ?>
						 <?php echo $lang['txt_hours']; ?> <br />
						<?php } else { ?>
						<?php echo round($e['event_duration']/24); ?> <?php echo $lang['txt_days']; ?> <br /><?php } ?>
						</td>
					</tr>
					<tr>
						<td colspan="3">
							<br />
						</td>
					</tr>
				<?php
				endforeach; } else { echo $lang['txt_no_events']; } ?>
				</table>
			</div>
		</div>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['frm_search']; ?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
			<form method="post" name="frm" id="id_frm" action="index.php?amn=evt_list">
				<?php if (isset($_SESSION['md5'])) { ?>
				<p>
					<?php if (!isset($_REQUEST['view']) || $_REQUEST['view'] == "latest") { ?>
						<?php echo $lang['txt_latest_events'] ?><br />
					<?php } else { ?>
						<a href="index.php?amn=evt_list&amp;view=latest"><?php echo $lang['txt_latest_events'] ?></a><br />
					<?php } if (!isset($_REQUEST['view']) || $_REQUEST['view'] == "today") { ?>
						<?php echo $lang['txt_events_today']; ?><br />
					<?php } else { ?>
						<a href="index.php?amn=evt_list&amp;view=today"><?php echo $lang['txt_events_today']; ?></a><br />
					<?php } if (isset($_REQUEST['view']) && $_REQUEST['view'] == "my_events") { ?>
						<?php echo $lang['txt_my_events']; ?><br />
					<?php } else { ?>
						<a href="index.php?amn=evt_list&amp;view=my_events"><?php echo $lang['txt_my_events']; ?></a><br />
					<?php } if (isset($_REQUEST['view']) && $_REQUEST['view'] == "my_attendance") { ?>
						<?php echo $lang['txt_my_attendance']; ?><br />
					<?php } else { ?>
						<a href="index.php?amn=evt_list&amp;view=my_attendance"><?php echo $lang['txt_my_attendance']; ?></a><br />
					<?php } ?>
				</p>
				
				<p>
					<b><?php echo $lang['frm_location']; ?></b><br />
					<select name="event_location" style="width: 140px;">
						<option value="1" <?php if (isset($data['event_location']) && $data['event_location'] == 1) echo "selected=\"selected\"";?>><?php echo $lang['frm_location_all']; ?></option>
						<option value="0" <?php if (isset($data['event_location']) && $data['event_location'] == 0) echo "selected=\"selected\"";?>><?php echo $lang['frm_location_local']; ?></option>
					</select>
				</p>
				<?php } else { ?>
					<input type="hidden" name="event_location" value="1" />
				<?php } ?>
				<p>
					<b><?php echo $lang['frm_search_text']; ?></b><br />
					<input type="text" class="input" name="search_text" value="<?php if (isset($data['search_text'])) echo $data['search_text']; ?>"/>
				</p>
				<br />
				<p>
					<b><?php echo $lang['frm_start_date']; ?></b><br />
					<input type="text" class="input" name="search_startdate" id="id_search_startdate" value="<?php if (isset($data['search_startdate'])) echo $data['search_startdate']; ?>"/>
					<img src="<?php echo $template_path_core;?>img/cal_icon.png" id="id_cal_pop1" border="0" alt="" hspace="2" onmouseover="this.style.background='red';" onmouseout="this.style.background='';" />
				</p>
				<br />
				<p>
					<b><?php echo $lang['frm_end_date']; ?></b><br />
					<input type="text" class="input" name="search_enddate" id="id_search_enddate" value="<?php if (isset($data['search_startdate'])) echo $data['search_enddate']; ?>"/>
					<img src="<?php echo $template_path_core;?>img/cal_icon.png" id="id_cal_pop2" border="0" alt="" hspace="2" onmouseover="this.style.background='red';" onmouseout="this.style.background='';" />
				</p>
				
				
				<script type="text/javascript">
			  		function dateChanged1(calendar) {
			  							
			  			if (calendar.dateClicked) { 
			  				var y = calendar.date.getFullYear();
			  				var m = calendar.date.getMonth()+1;     // integer, 0..11
			  				var d = calendar.date.getDate();      // integer, 1..31
			  				var h = calendar.date.getHours();      // integer, 1..31
			  				var i = calendar.date.getMinutes();      // integer, 1..31
			  		
			  				document.frm.id_search_startdate.value = y + '-' + m + '-' + d;
			  				/*document.frm.id_schedule_start_time.value = h + ':' + i;*/
			  				
			  				calendar.callCloseHandler();
			  			} 
			  							 	
			  		};
			  							
			  		Calendar.setup({           // our callback function
			  				        ifFormat       :    "%m-%d-%Y %k:%M",
			  						showsTime      :    true,
			  				        button         :    "id_cal_pop1",
			  				        singleClick    :    true,
			  				      	onSelect    : dateChanged1
			  				    });
			  				    
			  		function dateChanged2(calendar) {
			  							
			  			if (calendar.dateClicked) { 
			  				var y = calendar.date.getFullYear();
			  				var m = calendar.date.getMonth()+1;     // integer, 0..11
			  				var d = calendar.date.getDate();      // integer, 1..31
			  				var h = calendar.date.getHours();      // integer, 1..31
			  				var i = calendar.date.getMinutes();      // integer, 1..31
			  		
			  				document.frm.id_search_enddate.value = y + '-' + m + '-' + d;
			  				/*document.frm.id_schedule_start_time.value = h + ':' + i;*/
			  				
			  				calendar.callCloseHandler();
			  			} 
			  							 	
			  		};
			  							
			  		Calendar.setup({           // our callback function
			  				        ifFormat       :    "%m-%d-%Y %k:%M",
			  						showsTime      :    true,
			  				        button         :    "id_cal_pop2",
			  				        singleClick    :    true,
			  				      	onSelect    : dateChanged2
			  				    });
			  					  	
			  	</script>
				
				
				<br />
				<p>
					<?php if (isset($tags)) { ?>
					<b><?php echo $lang['frm_tags']; ?></b><br />
					<select name="event_tag" style="width: 140px;">
					<option value="0">-- <?php echo $lang['frm_tags']; ?> --</option>
					<?php foreach($tags as $t): ?>
					<option value="<?php echo $t['tag_body']; ?>"><?php echo $t['tag_body'];?></option>
					<?php endforeach; ?>
					</select>
					<?php } ?>
				</p>
				<p style="float: right;">
					<input name="search" type="submit" class="input_submit" value="<?php echo $lang['frm_search']; ?>" /><br />
				</p>
			</form>
			</div>
		</div>
	</div>
</div>