<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";

include_once($language_path . 'inc/evt_common.inc.php');

if (isset($_REQUEST['view'])) {
	$body->set('display', $_REQUEST['view']);
}

// Event setup ------------------------------------------------------------
include_once ("config/evt.config.php");
require_once ("class/Event.class.php");
$evt                = new Event($db, $core_config);
$evt->event_config  = $event_config;
$evt->date          = new Date;

if (isset($_SESSION['user_id'])) {
	$evt->user_id       = $_SESSION['user_id'];
	$evt->language_id   = $_SESSION['language_id'];
	$evt->location_id   = $_SESSION['location_id'];
}
else {
	$evt->event_config['view']['default_list'] = "all";
	$evt->level_id = $event_config['level']['public'];
}



// Setup File -------------------------------------------------------------
require_once ('components/core/class/File.class.php');
$file = new File($db, $core_config['file']);
$file->module_id = 0;
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];


if (isset($_REQUEST['view'])) {
	if ($_REQUEST['view'] == "latest") {
		$output_events = $evt->selEvents();
	}
	elseif ($_REQUEST['view'] == "my_events") {
		$output_events = $evt->selEvents(false, true);
	}
	elseif ($_REQUEST['view'] == "my_attendance") {
		$evt->my_attendance = true;
		$output_events = $evt->selEvents(true, true);
	}
	elseif ($_REQUEST['view'] == "today") {
		$evt->today = true;
		$output_events = $evt->selEvents(false, false);
	}
	else {
		$output_events = $evt->selEvents();
	}
}
elseif (isset($_POST['search']) || isset($_REQUEST['event_tag'])) {
	$output_events = $evt->searchEvents($_REQUEST);
	$body->set('data', $_POST);
}
else {
	$output_events = $evt->selEvents();
}

$output_tags = $evt->selTagCloud();

if (!empty($output_events)) {
	
	foreach($output_events as $key => $e) {
		$output_events[$key]['file'] = $file->selFile($e['file_id'], 't2');
	}
	$body->set('events', $output_events);
}

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

?>
