<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section= "event";

$output_event['item_id'] = $output_event['event_id'];
$body->set('item', $output_event);




// GET FAVOURITES --------------------------------------------------------
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['event']);

// get my bookmarked favourites
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
$output_bookmarks = $bookmark->selBookmarks(1);

if (!empty($output_bookmarks)) {
	// we get item_id's and we get the sets from that
	foreach ($output_bookmarks as $key => $i):
		$event->event_ids[] = $i['item_id'];
	endforeach;
	
	unset ($event->file, $event->single_event);
	
	if (!empty($event->event_ids)) {
		$output_bookmarks = $event->selEvents();
	}
	
	$body->set('recommendations', $output_bookmarks);
}


// GET USER STATISTICS ---------------------------------------------------
require_once('components/core/class/Statistic.class.php');
$statistic = new Statistic($db, $event_config['statistic']);
$statistic->module_id = $core_config['module_id']['event'];
$statistic->item_id = $output_event['event_id'];

$output_statistics['event'] = $statistic->selStatistics();

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}

	$query = "
		SELECT e.event_id, e.file_id, e.event_title, e.event_synopsis, e.event_start_datetime
		FROM " . $db->prefix . "_event e
		INNER JOIN " . $db->prefix . "_participation p
		ON p.module_id=" . $core_config['module_id']['event'] . "
		AND p.item_id=e.event_id
		WHERE p.identity_id=" . $_REQUEST['identity_id'] . " AND
		e.event_end_datetime < '" . date('Y-m-d H:i:s', time()) . "'
		ORDER BY e.event_end_datetime DESC"
	;
	
// 	$result = $db->Execute($query);
	$result = $db->selectLimit($query, 6);
	$output_events_done = array();
	if (isset($result->fields)) {
		while(!$result->EOF) {
			array_push($output_events_done, $result->fields);
			$result->moveNext();
		}
		$result->Close();
	}
	else {
		// error-code here
	}
	
	if (!empty($output_events_done)) {
		$file->module = 0;
		$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
		foreach($output_events_done as $key => $e) {
			$output_events_done[$key]['image'] = $file->selFile($e['file_id'], 't3'); 
		}
	
		$body->set('events_done', $output_events_done);
	}
	
	$query = "
		SELECT e.event_id, e.file_id, e.event_title, e.event_synopsis, e.event_start_datetime
		FROM " . $db->prefix . "_event e
		INNER JOIN " . $db->prefix . "_participation p
		ON p.module_id=" . $core_config['module_id']['event'] . "
		AND p.item_id=e.event_id
		WHERE p.identity_id=" . $_REQUEST['identity_id'] . " AND
		e.event_start_datetime > '" . date('Y-m-d H:i:s', time()) . "'
		ORDER BY e.event_start_datetime"
	;
	
	$result = $db->Execute($query);
	$output_events = array();
	if (isset($result->fields)) {
		while(!$result->EOF) {
			array_push($output_events, $result->fields);
			$result->moveNext();
		}
		$result->Close();
	}
	else {
		// error-code here
	}
	
	if (!empty($output_events)) {
		$file->module = 0;
		$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
		foreach($output_events as $key => $e) {
			$output_events[$key]['image'] = $file->selFile($e['file_id'], 't3'); 
		}
	
		$body->set('events', $output_events);
	}

// }

?>
