<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section= "group";

// the stylesheet editor allows group owners to create a set of styles 
// which can be applied to their full screen mode layout. We define the 
// tags that can be set and include a function to write the stylesheet 
// to the groups table

$allowable_styles = array();

// which elements do we want them to customise?
$allowable_styles[1]['element'] = "body";
$allowable_styles[2]['element'] = "#layout";
$allowable_styles[3]['element'] = "#content";
$allowable_styles[4]['element'] = "#content .box";
$allowable_styles[5]['element'] = "#content .box_top";
$allowable_styles[6]['element'] = "#content .box_mid";
$allowable_styles[7]['element'] = "a";
$allowable_styles[8]['element'] = "a:hover";
$allowable_styles[9]['element'] = "hr";

// within each element we allow style types
$allowable_styles[1]['styles'] = array('background-color', 'background-image', 'color');
$allowable_styles[2]['styles'] = array('background-color', 'color');
$allowable_styles[3]['styles'] = array('background-color', 'color');
$allowable_styles[4]['styles'] = array('background-color', 'color', 'border-top', 'border-left', 'border-right', 'border-bottom', 'border-style');
$allowable_styles[5]['styles'] = array('background-color', 'color', 'border-bottom');
$allowable_styles[6]['styles'] = array('background-color', 'color');
$allowable_styles[7]['styles'] = array('color');
$allowable_styles[8]['styles'] = array('color');
$allowable_styles[9]['styles'] = array('color', 'border-top', 'border-left', 'border-right', 'border-bottom', 'border-style');


// do we want them to apply custom styles to this module?
$allow_custom_styles = false;


// function to apply stylesheet to the group
function setStyleSheet_grp($group_id, $css) {
	
	global $db;
	
	$query = "
		SELECT group_id, group_css 
		FROM " . $db->prefix . "_group 
		WHERE 
		group_id=" . $group_id
	;
			
	$result = $db->SelectLimit($query, 1);
		
	if (isset($result->fields)) {
		$rec = array();
		$rec['group_css'] = $css;
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}

// select a stylesheet from the group
function selItem_grp($group_id) {
	
	global $db;
	
	$query = "
		SELECT group_id, group_css, group_title
		FROM " . $db->prefix . "_group 
		WHERE 
		group_id=" . $group_id
	;
			
	$result = $db->SelectLimit($query, 1);
		
	if (isset($result->fields)) {
		$item['item_id'] = $result->fields['group_id'];
		$item['item_title'] = $result->fields['group_title'];
		$item['item_css'] = $result->fields['group_css'];
			
		return $item;
	}
}


?>