<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

//setup group -------------------------------------------------
require_once('class/Group.class.php');
$group = new Group($db, $group_config);

if (isset($_POST['update_policy'])) {
	if (empty($_POST['group_policy'])) {
		$GLOBALS['am_error_log'][] = array('policy_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		updateGroupPolicy($_POST);
	}
	
	header("Location: index.php?amn=grp_item&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_group'])) {
	// check the group
	if (empty($_POST['group_title'])) {
		$GLOBALS['am_error_log'][] = array('title_empty');
	}
	
	if (!empty($_POST['group_unix_title'])) {
		checkGroupUnixTitle($_POST['group_unix_title'], $_POST['group_id']);
	}
	
	if (empty($_POST['group_synopsis'])) {
		$GLOBALS['am_error_log'][] = array('synopsis_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		updateGroup($_POST);
		
		if ($_POST['group_type'] == $group_config['type']['membership_type']) {
			setMembershipTypes($_POST['group_id'], $_POST['membership_types']);
		}
	}
	
	
	header("Location: index.php?amn=grp_item&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['insert_group'])) {
	// check the group
	if (empty($_POST['group_title'])) {
		$GLOBALS['am_error_log'][] = array('title_empty');
	}
	
	if (!empty($_POST['group_unix_title'])) {
		checkGroupUnixTitle($_POST['group_unix_title']);
	}
	
	if (empty($_POST['group_synopsis'])) {
		$GLOBALS['am_error_log'][] = array('synopsis_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		// we insert the group
		$_POST['group_policy'] = readTxtFile($language_path . "texts/group_policy.txt.php");
		$_POST['status_id'] = $group_config['status']['live'];
		
		$group_id = insertGroup($_POST);
		
		if (!empty($group_id)) {
			// insert arbiter
			$group->group_id = $group_id;
			
			// apply all permissions
			$arbiter_permissions = 0;
			
			if (!empty($group_config['resource']['user'])) {
				foreach ($group_config['resource']['user'] as $key => $i):
					$arbiter_permissions = $arbiter_permissions + $i;
				endforeach;
			}
			
			$user->identity_type = $core_config['user']['identity']['type']['registered'];
			
			$data['user_id'] = $_SESSION['user_id'];
			$data['participation_permission'] = $arbiter_permissions;
			$data['status_id'] = $group_config['user']['status']['active'];
			$data['identity_id'] = $_POST['identity_id'];
			$data['role_id'] = $group_config['role']['coordinator'];
			
			require_once('components/core/class/Participation.class.php');
			$participation = new Participation($db, $core_config);
			$participation->module_id = $core_config['module_id']['group'];
			$participation->item_id = $group_id;
			$participation->insertParticipant($data);
			
		
			if ($_POST['group_type'] == $group_config['type']['membership_type']) {
				setMembershipTypes($group_id, $_POST['membership_types']);
			}
			
			// we set the allocation
			$rec = array();
			$rec['module_id'] = $core_config['module_id']['group'];
			$rec['item_id'] = $group_id;
			$rec['file_allocation'] = $group_config['default_file_allocation'];
			
			$table = $db->prefix . "_file_allocation";
			
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			// if ok we go to group home
			header("Location: index.php?amn=grp_item&group_id=" . $group_id . "&" . strip_tags(SID));
			exit;
		}
	}
	
	$body->set('group', $_POST);
}
elseif (isset($_POST['preview_group'])) {
	$output_group = $_POST;
	$output_group['group_body'] = stripslashes($output_group['group_body']);
	
	require_once('components/core/class/Kses/kses.php');
	
	$output_group['display_group_body'] = kses_parse($output_group['group_body'], 'max');
	$output_group['display_group_body'] = stripslashes($output_group['display_group_body']);
	
	$body->set('group', $output_group);

	if (!empty($output_group['identity_id'])) {
		$output_identities = $user->selUserIdentities($_SESSION['user_id']);
		$body->set('identities', $output_identities);
	}
	
}
elseif (isset($_REQUEST['group_id'])) {
	$group->group_id = $_REQUEST['group_id'];
	$output_group = $group->selGroup();
	
	if ($output_group['user_id'] == $_SESSION['user_id']) {
		// move group to templates
		$tpl->set('group', $output_group);
		$body->set('group', $output_group);
		
		if (!empty($_REQUEST['policy'])) {
			$body->set('display', 'policy');
		}
	}
	else {
		header("Location: index.php?amn=grp_item&group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}


// get locations ----------------------------------------------
$output_locations = $user->selLocations($_SESSION['language_id']);

if (!empty($output_locations)) {
	$body->set('locations', $output_locations);
}


// file setup --------------------------------------------------
if (isset($output_group['group_id'])) {
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->core_config_module = $core_config['module'];
	$file->item_id = $output_group['group_id'];
	$file->module_id = $core_config['module_id']['group'];
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$file->thumbs = $core_config['file']['image']['thumb'];
	
	$images = $file->selFiles("images", "t2");

	if (!empty($images)) {
		$body->set("images", $images);
	}
}
else {
	$output_identities = $user->selUserIdentities($_SESSION['user_id']);
	$body->set('identities', $output_identities);
}

$body->set('module_id', $core_config['module_id']['group']);

// checkGroupUnixTitle --------------------------------------------------------------------
// checks that the group unix title is unique
// tom calthrop - 21st Feb 2004
//
function checkGroupUnixTitle ($group_unix_title, $group_id = null) {
	
	global $db;
	
	// check the name is correctly formatted	
	if (empty($GLOBALS['am_error_log'])) {
		// check that the formatting is ok
		// no spaces, no non 0-9, a-z or A-Z characters
		if(!preg_match('/^[A-Za-z0-9]+$/', $group_unix_title)) {
			$GLOBALS['am_error_log'][] = array('unixname_incorrect');
		}
	}
	
	//check the name is unique
	$query = "
		SELECT group_id 
		FROM " . $db->prefix . "_group 
		WHERE 
		group_unix_title=" . $db->qstr($group_unix_title, get_magic_quotes_gpc())
	;
	
	if (!empty($group_id)) {
		$query .= " AND group_id!=" . $group_id;
	}
	
	$result = $db->SelectLimit($query, 1);
	
	if (isset($result->fields['group_id'])) {
		$GLOBALS['am_error_log'][] = array('unixname_inuse');
	}
}



// insertGroup --------------------------------------------------------------------
// checks that the group unix title is unique
// tom calthrop - 21st Feb 2004
//
function insertGroup ($data) {
	
	global $db, $core_config;
	
	if (empty($data['language_id'])) {
		$data['language_id'] = $core_config['language']['default_id'];
	}
	
	//insert group
	$rec = array();
	$rec['group_title'] = trim(strip_tags($data['group_title']));
	
	if (!empty($data['group_unix_title'])) {
	    $rec['group_unix_title'] = $data['group_unix_title'];
	}
	
	$rec['group_synopsis'] = trim(strip_tags($data['group_synopsis']));
	$rec['group_body'] = $data['group_body'];
	$rec['group_policy'] = trim(strip_tags($data['group_policy']));
	$rec['language_id'] = $data['language_id'];
	$rec['level_id'] = $data['level_id'];
	
	if (empty($rec['group_title'])) {
		$GLOBALS['am_error_log'][] = array('title_empty');
	}
	
	if (empty($rec['group_synopsis'])) {
		$GLOBALS['am_error_log'][] = array('synopsis_empty');
	}
	
	if (empty($rec['group_policy'])) {
		$GLOBALS['am_error_log'][] = array('policy_empty');
	}
	
	if (!empty($data['location_id'])) {
		$rec['location_id'] = $data['location_id'];
	}
	
	$rec['group_create_datetime'] = time();
	$rec['group_type'] = $data['group_type'];
	
	if (!empty($data['group_from_age']) && $data['group_from_age'] > 0) {
	    $rec['group_from_age'] = $data['group_from_age'];
	}

	if (!empty($data['group_to_age']) && $data['group_to_age'] > 0) {
	    $rec['group_to_age'] = $data['group_to_age'];
	}
	
	$rec['user_id'] = $_SESSION['user_id'];
	
	if (!empty($data['file_id'])) {
		$rec['file_id'] = $data['file_id'];
	}
	
	
	$rec['status_id'] = $data['status_id'];
	
	$table = $db->prefix . "_group";
	
	if (empty($GLOBALS['am_error_log'])) {
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	
	
		if (isset($result)) {
			return $db->Insert_ID();
		}
		else {
			$error_info = "function=insertGroup in page grp_edit.php -- " . $query . " -- " . $db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}
}



// updateGroup --------------------------------------------------------------------
// checks that the group unix title is unique
// tom calthrop - 21st Feb 2004
//
function updateGroup ($data) {

	global $db, $core_config;
	
	
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_group  
		WHERE 
		group_id=" . $data['group_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
	
		if (empty($data['language_id'])) {
			$data['language_id'] = $core_config['language']['default_id'];
		}
		
		//update group
		$rec = array();
		$rec['group_title'] = trim(strip_tags($data['group_title']));
		
		if (!empty($data['group_unix_title'])) {
		    $rec['group_unix_title'] = $data['group_unix_title'];
		}
		
		$rec['group_synopsis'] = trim(strip_tags($data['group_synopsis']));
		$rec['group_body'] = $data['group_body'];
		$rec['language_id'] = $data['language_id'];
		$rec['level_id'] = $data['level_id'];
		
		if (!empty($data['location_id'])) {
			$rec['location_id'] = $data['location_id'];
		}
		
		$rec['group_type'] = $data['group_type'];
		
		if (!empty($data['group_from_age']) && $data['group_from_age'] > 0) {
		    $rec['group_from_age'] = $data['group_from_age'];
		}
	
		if (!empty($data['group_to_age']) && $data['group_to_age'] > 0) {
		    $rec['group_to_age'] = $data['group_to_age'];
		}
		
		$rec['user_id'] = $_SESSION['user_id'];
		
		if (!empty($data['file_id'])) {
			$rec['file_id'] = $data['file_id'];
		}
		
		if (empty($rec['group_title'])) {
			$GLOBALS['am_error_log'][] = array('title_empty');
		}
		
		if (empty($rec['group_synopsis'])) {
			$GLOBALS['am_error_log'][] = array('synopsis_empty');
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}
}



// updateGroupPolicy --------------------------------------------------------------------
// checks that the group unix title is unique
// tom calthrop - 21st Feb 2004
//
function updateGroupPolicy ($data) {

	global $db, $core_config;
	
	
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_group  
		WHERE 
		group_id=" . $data['group_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		//update group policy
		$rec = array();
		$rec['group_policy'] = trim(strip_tags($data['group_policy']));
		
		if (empty($data['group_policy'])) {
			$GLOBALS['am_error_log'][] = array('policy_empty');
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}
}



// setMembershipTypes --------------------------------------------------------------------
// deletes and inserts membership types
// tom calthrop - 12th December 2006
//
function setMembershipTypes ($group_id, $membership_types = null) {

	global $db, $core_config;
		
	// we add membership types to the am_module_membership_type_access table
	
	$query = "
		DELETE FROM " . $db->prefix . "_mem_type_access 
		WHERE 
		module_id=" . $core_config['module_id']['group'] . " AND 
		item_id=" . $group_id
	;
	
	if (!empty($membership_types)) {
		foreach ($membership_types as $key => $i) :
			$rec = array();
			$rec['module_id'] = $core_config['module_id']['group'];
			$rec['item_id'] = $group_id;
			$rec['membership_type_id'] = $i;
				
			$table = $db->prefix . "_mem_type_access";
				
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		endforeach;
	}
}

?>
