<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

if ($output_group['user_id'] != $_SESSION['user_id']) {
	header("Location: index.php?amn=grp_item&group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
	exit;
}


// move group to templates
$tpl->set('group', $output_group);
$body->set('group', $output_group);


if (isset($_POST['archive_group'])) {
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_group  
		WHERE 
		group_id=" . $_POST['group_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$rec = array();
		$rec['status_id'] = $group_config['status']['archive'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
	
	header("Location: index.php?amn=grp_list&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_ownership'])) {
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_group  
		WHERE 
		group_id=" . $_POST['group_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$rec = array();
		$rec['user_id'] = $_POST['user_id'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}

	header("Location: index.php?amn=grp_item&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_topic'])) {
	if (empty($_POST['topic_title'])) {	
		$GLOBALS['am_error_log'][] = array('no_title');	
	}
	
	if (empty($_POST['topic_synopsis'])) {	
		$GLOBALS['am_error_log'][] = array('no_synopsis');	
	}
	
	if (empty($_POST['topic_order'])) {
		$_POST['topic_order'] = "null";
	}
	
	if (empty($_POST['topic_hidden'])) {
		$_POST['topic_hidden'] = "null";
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$rec = array();
		$rec['group_id'] = $_POST['group_id'];
		$rec['topic_title'] = $_POST['topic_title'];
		$rec['topic_synopsis'] = $_POST['topic_synopsis'];
		$rec['topic_hidden'] = $_POST['topic_hidden'];
		$rec['topic_order'] = $_POST['topic_order'];
		$rec['user_id'] = $_SESSION['user_id'];
	
		if (!empty($_POST['topic_id'])) {
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_group_topic 
				WHERE 
				group_id=" . $_POST['group_id'] . " AND 
				topic_id=" . $_POST['topic_id']
			;
			
			$result = $db->Execute($query);
			
			if (isset($result->fields)) {
				$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
		}
		else { // insert
			$rec['topic_create_datetime'] = time();
			
			
			$table = $db->prefix . "_group_topic";
			
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}
	
	header("Location: index.php?amn=grp_manage&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_owner'])) {
	// we change group owner
	$query = "
		SELECT user_id, group_id 
		FROM " . $db->prefix . "_group 
		WHERE 
		group_id=" . $output_group['group_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$rec = array();
		
		if (!empty($_POST['new_owner_user_id']) && $_POST['new_owner_user_id'] > 0) {
			$rec['user_id'] = $_POST['new_owner_user_id'];
		}
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);	
		
		$output_group['user_id'] = $_POST['new_owner_user_id'];
	
	}
	
	// change now previous owner to coodinator
	$query = "
		SELECT user_id, group_role_id 
		FROM " . $db->prefix . "_group_participation 
		WHERE 
		group_id=" . $output_group['group_id'] . " AND 
		user_id=" . $_SESSION['user_id']
	;
		
	$result = $db->Execute($query);
		
	if (isset($result->fields)) {
		$rec = array();
		$rec['group_role_id'] = $group_config['role']['coordinator'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);	
		
		$_REQUEST['user_id'] = $_SESSION['user_id'];
	
	}
}


// select topics
$output_topics = $group->selTopics();

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}


if (!empty($_REQUEST['topic_id'])) {
	$output_topic = $group->selTopic($_REQUEST['topic_id']);
	
	if (!empty($output_topic)) {
		$body->set('topic', $output_topic);
	}
}

$output_coordinators = $participation->selParticipants(null, $group_config['role']['coordinator']);

if (!empty($output_coordinators)) {
	foreach ($output_coordinators as $key => $i):
		$user->identity_ids[] = $i['identity_id'];
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_coordinators = $user->selUserIdentities();
		$body->set('coordinators', $output_coordinators);
	}
}


// select tags
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, $core_config['module_id']['group'], $group_config['tag']['grp']['group']);
$tag->item_id = $output_group['group_id'];
$tag->level_id = $core_config['tag']['level']['item'];

if (isset($_POST['insert_tag'])) {
	if (empty($_POST['tag_id'])) { // we insert
		$tag->insertTag($_POST['tag_body']);
	}
	elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
		$tag->deleteTag($_POST['tag_id']);
	}
	else { // we update tag
		$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
	}
}
elseif (isset($_POST['delete_tag']) && !empty($_POST['tag_id'])) {
	$tag->deleteTag($_POST['tag_id']);
}
elseif (isset($_REQUEST['edit_tag'])) {
	$output_tag = $tag->selTag($_REQUEST['edit_tag']);

	if (!empty($output_tag)) {
	$body->set('tag', $output_tag);
	}
}

$output_tags = $tag->selTags();				

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

?>
