<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");

// if I receive a set_id I list the contents
// else I list the latest revisions
// if I search I list latest revisions with search criteria included


if (isset($_POST['search'])) {
	// search string should be over 3 chars long
	if (strlen(trim($_POST['search_text'])) < 3) {
		$GLOBALS['am_error_log'][] = array('search_size');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$search_text = trim($_POST['search_text']);
		
		$query = "
			SELECT DISTINCT s.set_id, s.set_title, p.page_title, p.page_id, 
			r.revision_body, r.revision_create_datetime, r.revision_id 
			FROM " . $db->prefix . "_library_set s," . $db->prefix . "_library_page p," . $db->prefix . "_library_revision r
			WHERE 
			s.set_id=p.set_id AND 
			s.default_page_id=p.page_id AND 
			p.page_id=r.page_id AND 
			(s.set_title like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . " OR 
			p.page_title like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . " OR 
			r.revision_body like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . ")"
		;
		
		if (!empty($_POST['local'])) {
			$query .= " AND p.current_revision_id=r.revision_id";
		}
		
		
		$query .= " order by s.set_title";
		
		$result = $db->Execute($query);
		
		$output_search = array();
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$temp = $result->fields;
				
				
				
				$temp['set_title'] = searchTextFormat($search_text, $temp['set_title']);
				$temp['page_title'] = searchTextFormat($search_text, $temp['page_title']);
				$temp['revision_body'] = searchTextFormat($search_text, $temp['revision_body']);
				
				array_push($output_search, $temp);
				$result->MoveNext();
			}
		}
		
		$body->set('revisions', $output_search);
	}
}
elseif (isset($_REQUEST['set_id'])) {
	// get the pages for a wiki set
	$library->order_by = "page_title";
	
	$output_pages = $library->selPages($_REQUEST['set_id'], 1);
	
	if (isset($output_pages)) {
		$body->set('pages', $output_pages);
	}
}
elseif (isset($_REQUEST['tag'])) {
	$query = "
		SELECT s.set_id, s.set_title, p.page_synopsis, 
		p.page_title, p.page_id 
		FROM " . $db->prefix . "_library_set s," . $db->prefix . "_library_page p," . $db->prefix . "_tag t
		WHERE 
		s.default_page_id=p.page_id AND 
		t.module_id=4 AND
		(t.item_id=s.set_id OR t.item_id=p.page_id) AND 
		t.tag_body like " . $db->qstr("%" . $_REQUEST['tag'] . "%", get_magic_quotes_gpc())
	;
	
	$query .= " order by s.set_title";
	//echo $query;
	$result = $db->Execute($query);
	
	$output_search = array();
	
	if (isset($result->fields)) {
		while (!$result->EOF) {
			$temp = $result->fields;
			array_push($output_search, $temp);
			$result->MoveNext();
		}
	}
	
	$body->set('tags', $output_search);
	
}
else {
	$body->set('display', 'intro');
}

if (!empty($output_revisions)) {
	$body->set('revisions', $output_revisions);
}


?>
