<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
$menu_section = "message";


// Handling message requests
if (isset($_POST['delete_messages'])) {
	if(isset($_POST['message_id']) & !empty($_POST['message_id']))
		$im->deleteMessages($_POST['message_id']);
	$update = "yes";
}
else if (isset($_POST['move_to_save'])) {
	$im->moveToSavebox($_POST['message_id']);
	$update = "yes";
}
else if (isset($_POST['set_unread_messages']) && isset($_POST['message_id'])) {
	$im->setMessagesStatus($_POST['message_id'], $im->getStatus("unread"));
	$update = "yes";
}
else if (isset($_POST['set_read_messages']) && isset($_POST['message_id'])) {
	$im->setMessagesStatus($_POST['message_id'], $im->getStatus("read"));
	$update = "yes";
}
else
	unset($update);


if(isset($update) || !empty($update)) {
	header("Location: msg_list.php?".$_SERVER["QUERY_STRING"] . "&amp;" . SID);
	exit;
}

//----------------------------------------------------------------------------
// Handling message box requests
if (isset($_REQUEST['out_box'])) {
	$message_box = "out_box";
}
elseif (isset($_REQUEST['save_box'])) {
	$message_box = "save_box";
}
else {
	$message_box = "in_box";
}

// Get the listing of the requested message box
$output_message = $im->getMessageBox($message_box);

//----------------------------------------------------------------------------

// Setting statistics
$im->setStatistics();

// Getting statistics
$output_message_statistics = $im->getStatistics();
//----------------------------------------------------------------------------


//move to template
$body->set('messages', $output_message);
$body->set('message_box', $message_box);
$body->set('message_statistics', $output_message_statistics);
$body->set('message_status_read', $c_node['messaging']['message_status_read']);
$body->set('message_status_unread', $c_node['messaging']['message_status_unread']);

$template_pageLink = "message list";
include "inc/footer.inc.php";

?>
