<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


class Message {

	//get db connect
	var $db;

	// message id
	var $message_id;

	// message status
	var $status;

	// holding the coding of the boxes
	var $boxes;

	// Set the user id and $db connection in the constructor for simplicity
	// Comment: It is useful to have a constructor without defining the message_id as well
	function Message($db, $message_id=null) {
		$this->db         = $db;
		$this->message_id = $message_id;
	}

	function setMessageId($message_id)
	{
		$this->message_id = $message_id;
	}

	// Set message status
	function setStatus($status)
	{
		$query = "UPDATE " . $this->db->prefix . "_user_message
			SET message_status=". $status .
			" WHERE message_id=". $this->message_id;

		// Setting the user to online
		$this->db->Execute($query);
		$this->status = $status;
	}

	// get message status
	function getStatus()
	{
		return $this->status;
	}

	// Set message box coding
	function setBoxes($inbox, $savebox, $outbox) {
		$this->boxes["in_box"]     = $inbox;
		$this->boxes["save_box"]   = $savebox;
		$this->boxes["out_box"]    = $outbox;

	}

	// Get the name of the box
	function getMessageBox($message_box) {

		if ($message_box == $this->boxes['out_box']) {
			$boxname = "out_box";
		}
		else if ($message_box == $this->boxes['save_box']) {
			$boxname = "save_box";

		}
		else if ($message_box == $this->boxes['in_box']) {
			$boxname = "in_box";
		}

		return $boxname;
	}

	// Setting the status of the message to read
	function getMessage()
	{

		// Getting the box id
		$query = "SELECT m.message_box FROM " . $this->db->prefix . "_user_message m
				WHERE m.message_id = " . $this->message_id;

		$result      = $this->db->Execute($query);
		$message_box = $result->fields["message_box"];

		/*
		Commented out that as it did not work properly
		$query = "
				SELECT u.user_nic, u.user_firstname, m.message_id, m.from_user_id, m.message_status, m.message_subject, m.message_body, m.message_create_datetime
				FROM br_user_message m
				LEFT JOIN br_user u on m.owner_user_id=u.user_id
				WHERE
				m.message_id = " . $this->message_id
				;*/

		// Selection of messages is differs for different boxes...
		if ($message_box == $this->boxes['out_box']) {
			$join = "m.to_user_id=u.user_id";
		}
		else if ($message_box == $this->boxes['save_box']) {
			$join = "m.owner_user_id=u.user_id";

		}
		else if ($message_box == $this->boxes['in_box']) {
			$join = "m.from_user_id=u.user_id";
		}

		// Forming query and selecting the messages with the correct owner id:s...
		// The \" m.to_user_id, m.owner_user_id, m.from_user_id \" are there so that one can track
		// everything about the users linked to that particular message outside the class.

		$query = "
		SELECT u.user_nic, u.user_firstname, m.message_id,
		m.owner_user_id, m.to_user_id, m.from_user_id, m.message_type, m.message_box,
		m.message_status, m.message_subject, m.message_body, m.message_create_datetime
		FROM " . $this->db->prefix . "_user_message m
		LEFT JOIN " . $this->db->prefix . "_user u on ". $join ." WHERE
		m.message_id = " . $this->message_id;
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$output_message = $result->fields;
			$result->Close();
		}
		return $output_message;

	}


}
?>
