<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
$section = "selection";

include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'User/Blog.class.php');


//append language setup
require_once($languageArrayPath . 'arr_genre.lang.php');


//setup blog
$blog = new Blog($user_id, $db, $date);
$blog->publish = $c_node['user_publish']['all'];
$blog->limit = 20;


if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$output_search_results = $blog->searchBlogs($search);

	$display = "search";

}
elseif (isset($_REQUEST['genre_id'])) {
	$genre_id = $_REQUEST['genre_id'];

	$blog->genre_id = $genre_id;

	$blogs_latest = $blog->getBlogs();
	
	if (isset($blogs_latest[0])) {
		$blogs_featured = array_slice($blogs_latest, 0, 2);
		$blogs_latest = array_slice($blogs_latest, 2);
	}

	$blog->publish = $c_node['user_publish']['friends'];
	$blogs_friends = $blog->getBlogs();

	$display = "genre";



}
elseif (isset($_REQUEST['weeks_most_read'])) {
	$now = mktime();
	$week_old = $now-(7*24*60*60);
	$two_week_old = $now-(14*24*60*60);
	
	$blog->publish = $c_node['user_publish']['all'];
	$blog->order_by = 'blog_total_views desc';
	
	$blog->after_timestamp = $week_old;
	$blog->limit = 30;
	
	$blogs_week = $blog->getBlogs();
	
	$blogs_featured = array_slice($blogs_week, 0, 2);
	$blogs_week = array_slice($blogs_week, 2);
	
	$blog->after_timestamp = $two_week_old;
	$blog->before_timestamp = $week_old;
	$blog->limit = 20;
	$blog_last_week = $blog->getBlogs();
	
	$display = "week";

}
else {//most recent blogs
	$blog->publish = $c_node['user_publish']['all'];
	$blog->order_by = 'blog_create_datetime desc';
	
	$blog->limit = 50;
	$blogs_week = $blog->getBlogs();

	if (isset($blogs_week)) {
		$blogs_featured = array_slice($blogs_week, 0, 2);
		$blogs_latest = array_slice($blogs_week, 2, 20);
		$blog_last_week = array_slice($blogs_week, 21, count($blogs_week));
	}
		
	$display = "most_recent";
}


//get featured images
if (isset($blogs_featured[0])) {
	if ($blogs_featured[0]['blog_image_id']) {
		$blogs_featured[0]['image'] = $image->getImage($blogs_featured[0]['blog_image_id'], 't2', 'user', $blogs_featured[0]['user_id']);
	}
	else {
		$blogs_featured[0]['image']['image'] = "blog/no_blog_t2.gif";
		$blogs_featured[0]['image']['image_title'] = $blogs_featured[0]['blog_title'];
	}
}

if (isset($blogs_featured[1])) {
	if ($blogs_featured[1]['blog_image_id']) {
		$blogs_featured[1]['image'] = $image->getImage($blogs_featured[1]['blog_image_id'], 't2', 'user', $blogs_featured[1]['user_id']);
	}
	else {
		$blogs_featured[1]['image']['image'] = "blog/no_blog_t2.gif";
		$blogs_featured[1]['image']['image_title'] = $blogs_featured[1]['blog_title'];;
	}

}


//move to template
if (isset($blogs_friends)) {
	$body->set('blogs_friends', $blogs_friends);
}

if (isset($blogs_latest)) {
	$body->set('blogs_latest', $blogs_latest);
}

if (isset($blogs_week)) {
	$body->set('blogs_week', $blogs_week);
}

if (isset($blog_last_week)) {
	$body->set('blog_last_week', $blog_last_week);
}

if (isset($blogs_featured)) {
	$body->set('blogs_featured', $blogs_featured);
}

if (isset($genre_id)) {
	$body->set('genre_id', $genre_id);
}

if (isset($output_search_results)) {
	$body->set('search_results', $output_search_results);
}

if (isset($search)) {
	$body->set('search', $search);
}

if (isset($display)) {
	$body->set('display', $display);
}

$template_pageLink = $lang['hdr_selection'];
include "inc/footer.inc.php";
?>
