<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Cms.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];


//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'group/');

$output_group['group_home_synopsis'] = $wiki->transform($output_group['group_home_synopsis'], 'Xhtml');
	


//get group image
if (!empty($output_group['file_id'])) {
	$file->file_id = $output_group['file_id'];
	$output_group['image'] = $file->getFileRecord();
}
else {
	$output_group['image']['file_title'] = "";
	$output_group['image']['file'] = $file->noimage;
}


$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


//setup statistics
$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
$statistic->section_item_id = $group_id;
$statistic->no_user_id = 1;
$output_statistic = $statistic->getStatistics();


//setup cms
$group_cms = new Cms($db, $c_acs['arr_section']['group']);
$group_cms->section_item_id = $group_id;
$group_cms->status_id = $c_node['cms']['status']['live'];
$group_cms->level_id = $c_node['cms']['cms_level']['group']['home'];



//setup forum --------------------------------------------------------------
$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);
$forum->section_item_id = $group_id;
$forum->cms_item_type_id = $c_node['cms']['item_type']['group_forum_subject'];
//get subjects
$group_cms->cms_item_type_id = $c_node['cms']['item_type']['group_forum_subject'];
$output_cms_subjects = $group_cms->getCmsItems();
foreach($output_cms_subjects as $key => $i):
	$forum->subject_ids[] = $i['item_id'];
endforeach;
if (!empty($forum->subject_ids)) {
	$output_subjects = $forum->getSubjects();
}
//setup blog ----------------------------------------------------------------
$blog = new Blog($db, $c_acs['arr_section']['group'], $date, $file);
$blog->section_item_id = $group_id;
//get blogs
$group_cms->cms_item_type_id = $c_node['cms']['item_type']['group_blog'];
$output_cms_blogs = $group_cms->getCmsItems();
foreach($output_cms_blogs as $key => $i):
	$blog->blog_ids[] = $i['item_id'];
endforeach;

if (!empty($blog->blog_ids)) {
    $output_blogs = $blog->getBlogs();
}
//setup poll ----------------------------------------------------------------
$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->section_type_id = $group_id;
//get polls
$group_cms->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
$output_cms_polls = $group_cms->getCmsItems();

foreach($output_cms_polls as $key => $i):
	$poll->poll_ids[] = $i['item_id'];
endforeach;

if (!empty($poll->poll_ids)) {
    $output_polls = $poll->getPolls();
}
//library setup -----------------------------------------------------------------
$library = new Library($db, $c_acs['arr_section']['group'], $date, $file);
$library->section_item_id = $group_id;
//get library items
$group_cms->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
$output_library_items = $group_cms->getCmsItems();
foreach($output_library_items as $key => $i):
	$library->library_item_ids[] = $i['item_id'];
endforeach;

if (!empty($library->library_item_ids)) {
	$output_library = $library->getLibraryItems();
}
//activity setup ----------------------------------------------------------------
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $group_id;
//get activities
$group_cms->cms_item_type_id = $c_node['cms']['item_type']['group_activity'];
$output_cms_activities = $group_cms->getCmsItems();
foreach($output_cms_activities as $key => $i):
	$activity->activity_ids[] = $i['item_id'];
endforeach;
if (!empty($activity->activity_ids)) {
	$output_activities = $activity->getActivities();
}
//task setup ----------------------------------------------------------------
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];
//get tasks
$group_cms->cms_item_type_id = $c_node['cms']['item_type']['group_task'];
$output_cms_tasks = $group_cms->getCmsItems();
foreach($output_cms_tasks as $key => $i):
	$activity->task_ids[] = $i['item_id'];
endforeach;
if (!empty($activity->task_ids)) {
	$output_tasks = $activity->getTasks();
}



//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (!empty($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
}


if (!empty($output_group['group_title'])) {
	$template_pageLink = $lang['txt_group'];
	$template_pageLinkNote = $output_group['group_title'];
}

include "inc/footer.inc.php";

?>
