<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_library'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_library.php?group_id=" . $output_group['group_id']."&".SID);
	exit;
}


if (isset($_REQUEST['library_id'])) {
	$library_id = $_REQUEST['library_id'];
}
elseif (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}
else {
	header("Location: g_library.php?group_id=" . $group_id . "&" . SID);
	exit;
}


require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_group.lang.php');


//setup Library
$library = new Library($db, $c_acs['arr_section']['group'], $date, $file);
$library->section_item_id = $group_id;
$library->user_id = $user_id;


//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'g_library.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'g_library_edit.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'group/');


// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();



if (isset($data)) {//post data received

	$data['library_body'] = stripslashes($data['library_body']);
	$data['library_body_display'] = $wiki->transform($data['library_body'], 'Xhtml');
	$data['library_synopsis'] = stripslashes(htmlspecialchars($data['library_synopsis']));
	$data['library_title'] = stripslashes(htmlspecialchars($data['library_title']));
	$data['library_page_name'] = $page;

	if (isset($_POST['preview_library'])) {
		$data['library_body'] = htmlspecialchars($data['library_body']);

		$output_library = $data;

		$display = "preview_library";
	}
	elseif (isset($_POST['edit_library_again'])) {
		$output_library = $data;

		$display = "add_library";

	}
	elseif (isset($_POST['insert_library'])) {
		if (!empty($data['cms_public'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['public'];
		}
		elseif (!empty($data['cms_node'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['node'];
		}
		elseif (!empty($data['cms_group'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['group'];
		}
		else {
			$data['level_id'] = null;
		}
		
		$insert = $library->insertLibrary($data);

		if (empty($GLOBALS['am_error_log'])) {
			//setup cms
			require_once($c_node['dir']['class_path'] . 'Cms.class.php');
			$cms = new Cms($db, $c_acs['arr_section']['group']);
			$cms->section_item_id = $group_id;
			$cms->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
			$cms->user_id = $user_id;
			$temp['language_id'] = $output_group['language_id'];
			$temp['genre_id'] = $output_group['genre_id'];
			$temp['item_id'] = $library->library_id;
			
			//insert node cms entry
		  	if($c_node['cms']['node']['auto_publish'] == 1) {
				$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
				
			if (isset($data['cms_node'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['node'];
				$cms->insertCmsItem($temp);
			}
			
			if (isset($data['cms_public'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['public'];
				$cms->insertCmsItem($temp);
			}
			
			//insert group cms entry
			if (isset($data['cms_group'])) {
				$temp['level_id'] = $c_node['cms']['cms_level']['group']['home'];
				$cms->insertCmsItem($temp);
			}
			
			//setup statistics
			require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
			$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
			
			//update stats
			$statistic->section_item_id = $user_id;
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_library_items'];
			$library->user_id = $user_id;
			$statistic->setStatistic($library->getLibraryItemCount());
			
			header("Location: g_library.php?group_id=" . $group_id . "&page=" . $page . "&" . SID);
			exit;
		}
		else {
			$output_library = $data;

			$display = "add_library";
		}
	}
}
elseif (isset($library_id)) {//if we have a library id we retrieve it
    $output_library = $library->getPageID($library_id);

	$display = "add_library";
	
}
elseif (isset($page)) {//else we assign the new page name
	$output_library = $library->getPageName($page);
	
	if (empty($output_library)) { //is a new page
	    $output_library['library_page_name'] = $page;
	}
	
	$display = "add_library";
}

//handle new libraries - we've deleted all library items and now adding new one
if (isset($output_library['library_page_name']) && !isset($output_library['library_id']) && ($output_library['library_page_name'] == $lang['txt_wiki_default'])) {
	$output_library['library_default'] = 1;
}


if (isset($output_library['user_id'])) {
	$user->user_id = $output_library['user_id'];
	$output_author = $user->getProfile();
	$output_author['profile_create_datetime'] = $date->formatDate($output_author['profile_create_datetime']);
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($pages)) {
	$body->set('pages', $pages);
}

$body->set('cms_node_auto_publish', $c_node['cms']['node']['auto_publish']);

include "inc/footer.inc.php";

?>
