<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_activity'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}


require_once($c_node['dir']['class_path'] . 'Calendar.class.php');


//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');
require_once($languageArrayPath . 'arr_task_user_status.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
$file->path = "group";


//setup activities
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $group_id;
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];


if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$output_activities = $activity->getActivities($search);
	$output_tasks = $activity->getTasks($search);
}
else {
	$output_activities = $activity->getActivities();
	$output_tasks = $activity->getTasks();
}

//calendar stuff ----------------------------------------------------------


//setup calendar
if(!isset($_REQUEST["time"])) {
	$time = mktime();
}
else {
	$time = $_REQUEST["time"];
}

$now = getdate($time);

$cal = new Calendar($db, $now, $me['user_id']);

//get date
$cal->setCalendarBase();


if (!empty($output_activities)) {
	foreach($output_activities as $index => $activity_tmp):
		if(isset($activity_tmp)) {
			$activities[] = $cal->modifyActivityDate($activity_tmp);
		}
	endforeach;
}





// Populate all activities
if (!empty($activities)) {
	foreach($activities as $index => $activity_tmp):
		$cal->populateActivity($activity_tmp);
	endforeach;
}

$cal->setBlankDays();             // Set blank days in the beginning of the calendar
$calendar = $cal->getCalendar();  // Get the calendar array


// get today's day number to highlight today in calendar,
// a string is only returned if the calendar view is current month
$todaynumber = $cal->getToDay(mktime());

// Get last and next months timestamp
$links["last"] = $date->getMonthTime($time, -1);
$links["next"] = $date->getMonthTime($time, 1);

// Get the calendar view month name
$thismonth = $date->getMonthString($time);


//move to template
if (isset($output_group)) {
   $body->set('group', $output_group);
}

if (isset($output_activities)) {
   $body->set('activities', $output_activities);
}

if (isset($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($search)) {
	$body->set('search', $search);
}

if (!empty($time)) {
	$body->set('time', $time);
}

if (!empty($calendar)) {
	$body->set('calendar', $calendar);
}

if (isset($todaynumber)) {
	$body->set('todaynumber', $todaynumber);
}

if (!empty($thismonth)) {
	$body->set('thismonth', $thismonth);
}

if (!empty($links)) {
	$body->set('links', $links);
}

$template_pageLink = $lang['txt_activities'];
include "inc/footer.inc.php";

?>
