<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}


require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup bookmarks (to get subject movements)
$bookmark = new Bookmark($db, $c_node['cms']['item_type']['group_forum_subject'], $date, $user_id);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//setup comment
$comment = new Comment($db, $c_node['cms']['item_type']['group_forum_subject'], $date);
$comment->section_item_id = $group_id;
$comment->user_id = $user_id;


//setup forum
$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);
$forum->section_item_id = $group_id;
$forum->bookmark = $bookmark;
$forum->comment = $comment;

//ACS check
if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_hidden'])) { //resourece_id, Priv_id
	$forum->include_hidden = 1;
}



if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$output_topics = $forum->getTopics(1, $search); //show subjects, search
}
else {
	$output_topics = $forum->getTopics(1, null); //show subjects, search
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_topics)) {
    $body->set('topics', $output_topics);
}

if (!empty($output_subject_search_results)) {
	$body->set('subject_search_results', $output_subject_search_results);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($search)) {
	$body->set('search', $search);
}

if (!empty($output_group['group_title'])) {
    $template_pageLink = $lang['txt_forum'];
	$template_pageLinkNote = $output_group['group_title'];
}

include "inc/footer.inc.php";

?>
