<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');


if (isset($_REQUEST['profile_id'])) {
	$profile_id = $_REQUEST['profile_id'];
    $user->profile_id = $profile_id;
}


//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'user/');


//setup file
$file->user_id = $me['user_id'];


//setup group
require_once($c_node['dir']['class_path'] . 'Group.class.php');
$group = new Group($db, $date, $file);
$group->user_id = $me['user_id'];


if (isset($_REQUEST['edit_profile'])) {
	$output_profile = $user->getProfile($_REQUEST['profile_id']);
	
	$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
	$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
	$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
	$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif
    $output_images = $file->getFiles();//get images for default image selections
	
	$output_group_profiles = $group->getMyGroupProfiles($output_profile['profile_id']);
	
	$display = "edit_profile";
}
elseif (isset($_REQUEST['add_profile'])) {
	$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
	$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
	$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
	$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif
    $output_images = $file->getFiles();//get images for default image selections
	
	$display = "edit_profile";
}
elseif (isset($_REQUEST['insert_profile'])) {
	
	$user->insertProfile($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: my_profile.php?profile_id=". $user->profile_id . "&" . SID);
		exit;
	}
	else {
		$output_profile = $data;
		$display = "edit_profile";
	}
}
elseif (isset($_REQUEST['update_profile'])) {
	
	$user->updateProfile($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: my_profile.php?profile_id=". $profile_id . "&" . SID);
		exit;
	}
	else {
		$output_profile = $data;
		$display = "edit_profile";
	}
	
}
elseif (isset($_REQUEST['delete_profile'])) {
	
	$user->deleteProfile($profile_id);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: my_profile.php?" . SID);
		exit;
	}
	
}
elseif (isset($_REQUEST['set_default'])) {
	
	$user->updateDefaultProfile($data['default_profile_default']);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: my_profile.php?" . SID);
		exit;
	}
	
}
elseif (isset($_REQUEST['set_degree'])) {
	
	$user->updateDegreeProfiles($data['set_degree_profile_ids']);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: my_profile.php?" . SID);
		exit;
	}
	
}
elseif (isset($profile_id)) {
	
	$output_profile = $user->getProfile($_REQUEST['profile_id']);
	$output_profile['profile_summary_display'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');
	
	$output_group_profiles = $group->getMyGroupProfiles($output_profile['profile_id']);
	
	$display = "view_profile";
}
else {
	//setup file
	$user->file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$user->file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$output_profiles = $user->getProfiles();
	
	$output_group_profiles = $group->getMyGroupProfiles();
	
	$output_degree_profiles = $user->getDegreeProfiles();
}

//setup file
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];

if (isset($output_profile['file_id'])) {
	$file->file_id = $output_profile['file_id'];
	$output_profile['image'] = $file->getFileRecord();
}
elseif (isset($output_profile)) {
	$output_profile['image']['file_title'] = "";
	$output_profile['image']['file'] = $file->noimage;
}



//move to template
if (!empty($output_user)) {
   $body->set('user', $output_user);
}

if (!empty($display)) {
   $body->set('display', $display);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_profiles)) {
   $body->set('profiles', $output_profiles);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
}

if (!empty($output_group_profiles)) {
	$body->set('group_profiles', $output_group_profiles);
}

if (!empty($output_degree_profiles)) {
	$body->set('degree_profiles', $output_degree_profiles);
}

include "inc/footer.inc.php";

?>
