<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";

require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');


if (isset($_REQUEST['blog_id'])) {
    $blog_id = $_REQUEST['blog_id'];
}


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];



//get blogs
$blog = new Blog($db, $c_acs['arr_section']['user'], $date, $file);
$blog->section_item_id = $user_id;
$blog->limit = 5;
$blog->degree_id = $degree_path['degree'];


//setup comment
$comment = new Comment($db, $c_node['cms']['item_type']['user_blog'], $date);
$comment->user_id = $user_id;
$comment->section_item_id = $user_id;

		
//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');


//setup bookmarks
$bookmark = new Bookmark($db, $c_node['cms']['item_type']['user_blog'], $date, $user_id);


//process requests
if (isset($_POST['preview'])) {
	$output_comment = $data;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['display_comment_body'] = nl2br(htmlspecialchars($output_comment["comment_body"], ENT_QUOTES));
	$output_comment['comment_body'] = str_replace ('"', '&quot;', $output_comment['comment_body']);
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $blog_id;
	$comment->insertComment($data);
		
	if (empty($GLOBALS['am_error_log'])) {
		//update user stats
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
		$statistic->section_item_id = $me['user_id'];
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$statistic->section_id = $c_acs['arr_section']['user'];
		$statistic->setStatistic($comment->getCommentCount());
		
		//goto the subject
		return header("Location: sn_blog.php?user_id=". $user_id . "&blog_id=". $blog_id . "&" . SID);
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $data;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}


if (isset($blog_id)) {
	$blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();
	
	if (isset($output_blog['blog_id'])) {
		$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');
		
		$bookmark->item_id = $output_blog['blog_id'];
		
		//watching
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		//set or unset bookmarks
		if (isset($_REQUEST['watch'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_REQUEST['unwatch'])) {
			$bookmark->deleteBookmark();
		}
		//get and update bookmark
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_blog['bookmark']['watch'] = 1;
		}
		
		//recommended
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		//set or unset bookmarks
		if (isset($_REQUEST['recommend'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_REQUEST['unrecommend'])) {
			$bookmark->deleteBookmark();
		}
		//get and update bookmark
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_blog['bookmark']['recommend'] = 1;
		}
		
		if (isset($output_blog['user_id'])) {
			$user->user_id = $output_blog['user_id'];
	    	$output_author = $user->getProfile();
		}
		
		$comment->item_id = $blog_id;
		$output_comments = $comment->getComments($blog_id);
	}

}
elseif (isset($_REQUEST['blog_history'])) {
	unset($blog->limit);
	$blog_history = $blog->getBlogs();
	
	$display = "blog_history";
}
else {
	$output_blogs = $blog->getBlogs();
	
	if (!empty($output_blogs)) {
	    foreach($output_blogs as $key => $i):
			$output_blogs[$key]['blog_body_display'] = $wiki->transform($i['blog_body'], 'Xhtml');
			
			$bookmark->item_id = $i['blog_id'];
			
			//watching
			$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
			
			//get and update bookmark
			if ($bookmark->getBookmark()) {
				$bookmark->updateBookmark();
				$output_blogs[$key]['bookmark']['watch'] = 1;
			}
			
			//recommended
			$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
			
			//get and update bookmark
			if ($bookmark->getBookmark()) {
				$bookmark->updateBookmark();
				$output_blogs[$key]['bookmark']['recommend'] = 1;
			}
			
			$output_blogs[$key]['comment_total'] = $comment->getCommentCount($i['blog_id']);
			
		endforeach;
	}
	
	$display = "multiple_blogs";
}


//move vars to template
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($blog_history)) {
	$body->set('blog_history', $blog_history);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}


if (isset($output_blog['blog_title'])) {
    $template_pageLink = $lang['txt_blog'];
	$template_pageLinkNote = $output_blog['blog_title'];
}

include "inc/footer.inc.php";

?>