<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

//append language setup
require_once($languageArrayPath . 'arr_category.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');


//setup group
$group->group_visibility = 1;
$group->file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$group->file->thumb = $c_node['file']['image']['thumb'][3]['name'];



if (isset($_REQUEST['my_groups'])) {
	$output_groups = $group->getMyGroups();
	
	$display = "mygroups";
}
else {
	if (isset($_REQUEST['category_parent_id'])) {
	    $category_parent_id = $_REQUEST['category_parent_id'];
		
		if ($category_parent_id > 0) {
			$group->category_parent_id = $category_parent_id;
			
			$display = "category";
		}
		
	}
	else {
		$category_parent_id = 0;
		$group->limit = 25; // display latest groups
	}
	
	$output_groups = $group->getGroups();
	
	//get category sub groups and build total
	$output_categories = array();
	if (isset($arr_category['tree'])) {
		foreach($arr_category['tree'] as $key => $i):
			//
			if ($i['parent_id'] == $category_parent_id) {
				$i['total'] = $group->countCategories($key);
				$i['category_id'] = $key;
				array_push($output_categories, $i);
			}
		endforeach;
	}
	
	$category_count = $group->countCategories($category_parent_id);
	
}


//setup statistics
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
$output_group_statistics = $statistic->getGroupStatistics();




//move to template
if (!empty($output_groups)) {
	$body->set('groups', $output_groups);
}

if (!empty($output_group_statistics)) {
	$body->set('group_statistics', $output_group_statistics);
}

if (isset($category_parent_id)) {
	$body->set('category_parent_id', $category_parent_id);
}

if (!empty($output_categories)) {
	$body->set('categories', $output_categories);
}

if (isset($category_count)) {
	$body->set('category_count', $category_count);
}

if (!empty($arr_category)) {
	$body->set('arr_category', $arr_category);
}

if (isset($display)) {
	$body->set('display', $display);
	$tpl->set('display', $display);
}


$template_pageLink = "groups";
include "inc/footer.inc.php";

?>
