<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$path = dirname(__FILE__) . "/";

session_start();
include $path . "../config/config_aroundme.inc.php";
include $path . "../inc/functions.inc.php";


// SETUP LOGGING ---------------------------------------------------
$GLOBALS['am_log'] = $c_node['log'];


// SETUP DATABASE ----------------------------------------------------------
require_once($path . '../class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
if ($db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db'])) {
	$db->prefix = $c_node['db']['prefix'];
	
	
	// SETUP MAIL -------------------------------------------------------------
	require_once($path . '../class/Mail/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->Host = 		$c_node['mail']['host'];
	$mail->Port = 		$c_node['mail']['port'];
	$mail->Mailer = 	$c_node['mail']['mailer'];
	
	if (isset($c_node['mail']['smtp']['username'])) {
		$mail->SMTPAuth = true;
		$mail->Username = $c_node['mail']['smtp']['username'];
		$mail->Password = $c_node['mail']['smtp']['password'];
	}
	
	$mail->From = 		$c_node['mail']['no_reply_address'];
	$mail->FromName = 	$c_node['mail']['from_name'];
	$mail->WordWrap = 	$c_node['mail']['wordwrap'];
	$mail->Priority = 			3;
	$mail->Encoding = 			"8bit";
	$mail->CharSet = 			"iso-8859-1";
	$mail->SMTPKeepAlive =      true;
	$mail->IsHTML(true);
	
	
	// SETUP WIKI  -------------------------------------------------------------
	$c_node['class_path'] = $path . "../";
	require_once($path . '../class/Wiki/Wiki.php');
	$wiki = new Text_Wiki();
	$wiki->disableRule('wikilink');
	$wiki->disableRule('freelink');
	
	
	//SETUP DATE ---------------------------------------------------------------
	require_once($path . '../class/Date.class.php');
	$date = new Date();
	
	
	// SETUP USER --------------------------------------------------------------
	require_once($path . '../class/User.class.php');
	$user = new User($db, $date);
	
	
	// SETUP BLOGS -------------------------------------------------------------
	require_once($path . '../class/Blog.class.php');
	$blog = new Blog($db, null, null);
	
	
	// SETUP LIBRARY -----------------------------------------------------------
	require_once($path . '../class/Library.class.php');
	$library = new Library($db, null, null);
	
	
	// SETUP SCHEDULE ----------------------------------------------------------
	require_once($path . '../class/Schedule.class.php');
	$schedule = new Schedule($db, null, $date, null);
	$schedule->schedule_config = $c_node['schedule'];
	
	
	// SETUP POLLS  ------------------------------------------------------------
	require_once($path . '../class/Poll.class.php');
	$poll = new Poll($db, null);
	
	
	// SETUP FORUM  ------------------------------------------------------------
	require_once($path . '../class/Forum.class.php');
	$forum = new Forum($db, null, null);
	
	
	// SETUP BOOKMARKS  --------------------------------------------------------
	require_once($path . '../class/Bookmark.class.php');
	$bookmark = new Bookmark($db, null, null);
	
	
	// SETUP COMMENTS  ---------------------------------------------------------
	require_once($path . '../class/Comment.class.php');
	$comment = new Comment($db, null);
	$comment->wiki = $wiki;
	
	
	// SETUP STATISTICS  -------------------------------------------------------
	require_once($path . '../class/Statistic.class.php');
	$statistic = new Statistic($db);
	
	
	// SETUP NETWORK  ----------------------------------------------------------
	require_once($path . '../class/SocialNetwork.class.php');
	$sn = new Socialnetwork(null, $db, $c_node['sn']['max_degree']);
	$sn->relation_type_ids = $c_node['user']['relation_type'];
	$sn->status_ids = $c_node['user']['status'];
	
	
	// select newsletter
	$sqlnlday = $db->SQLDate('%w','message_create_datetime'); //w: day of week (0-6 or 1-7 depending on DB)
	
	$nl_query = "
		SELECT message_id, message_create_datetime, status_id, start_user_id, " . $sqlnlday . " as nl_day 
		FROM " . $db->prefix . "_newsletter 
		WHERE 
		to_type_id=" . $c_node['newsletter']['type']['digest'] . "
		order by message_create_datetime desc"
	;
	
	$nl_result = $db->SelectLimit($nl_query, 1, 0);
	
	if (!isset($nl_result->fields['message_id'])) {
		//we create the record
		$make_new_record = 1;
	}
	elseif (isset($nl_result->fields['status_id']) && $nl_result->fields['status_id'] == 2) {
		// we check to see how old the newsletter is. If yesterday we create new
		$nlt_date = substr($nl_result->fields['message_create_datetime'],8,2);
		$today_date = date('d');
		
		if ($nlt_date != $today_date) {
			//we create the record
			$make_new_record = 1;
		}
		else {
			exit;
		}
	}
	
	
	if (isset($make_new_record)) {
		$rec = array();
		$rec['to_type_id'] = $c_node['newsletter']['type']['digest'];
		$rec['message_create_datetime'] = time();
		$rec['start_user_id'] = 0;
		$rec['status_id'] = 0;
		
		$table = $db->prefix . "_newsletter";
		
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		unset($nl_result);
		
		$nl_result = $db->SelectLimit($nl_query, 1, 0);
	}
	
	// if the message status == 0 then we run the script...
	if (isset($nl_result->fields['message_id'])) {
		// select the users that registered on the same day as the newsletter 
		
		$sqlday = $db->SQLDate('%w','user_create_datetime'); //w: day of week (0-6 or 1-7 depending on DB)
		
		$query = "
			SELECT u.user_id, u.user_email, u.user_firstname, u.language_id 
			FROM " . $db->prefix . "_user u, " . $db->prefix . "_user_preference up 
			WHERE 
			u.user_id=up.user_id AND 
			" . $sqlday . "=" . $nl_result->fields['nl_day'] . " AND 
			up.user_preference_id=1 AND 
			u.user_id>" . $nl_result->fields['start_user_id']
		;
		
		$result = $db->SelectLimit($query, $c_node['newsletter']['nr_per_batch']);
		
		if (!empty($result)) {
			// we assemble the newsletter for each user
			$lastWeek = time() - (7 * 24 * 60 * 60);
			
			while(!$result->EOF){
				// create the newsletter body
				$message_body_text = "";
				$message_body_html = "";
				
				// GET LANGUAGE
				$languagePath = "../language/" . $result->fields['language_id'] . "/" . $c_node['node']['template_default_name'] . "/";
				include $languagePath . 'nlt_digest_send.lang.php';
				include $languagePath . 'arrays/arr_user.lang.php';
				include $languagePath . 'sn_list.lang.php';
				
				// greeting
				$message_body_text .= $lang['txt_greeting'] . " " . $result->fields['user_firstname'] . ",\n\n";
				$message_body_html .= $lang['txt_greeting'] . " " . $result->fields['user_firstname'] . ",<br /><br />";
				
				$message_body_text .= $lang['txt_intro'] . "\n\n\n";
				$message_body_html .= $lang['txt_intro'] . "<br /><br /><br />";
				
				
				// Setup of the email
				$mail->Subject = $lang['txt_subject'];
				
				
				//setup URL
				//create URL
				$url = "http://" . $_SERVER['HTTP_HOST'];
				$url .= dirname ($_SERVER['PHP_SELF']);
				$url = str_replace("/batch", "", $url);
				//sometimes the server adds / as the last characture - we need to check.
				if (substr($url, -1, 1) != "/") {
					$url .= "/";
				}
				
				
				// GET SPLASH LATEST BLOGS ---------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$blog->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
				$blog->rsp_status_id = $c_node['rsp']['status']['live'];
				$blog->limit = 5;
				$rsp_blogs = $blog->selBlogs();
				unset($blog->rsp_level_id, $blog->rsp_status_id, $blog->limit);
				
				
				if (isset($rsp_blogs)) {
					foreach($rsp_blogs as $key => $i):
						//format url
						$b_url = $url . "blg_view.php?blog_id=" . $i['blog_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
						$comment_count = $comment->getCommentCount($i['blog_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['blog_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $i['blog_synopsis'] . "\n";
						$message_body_text_tmp .= $b_url . "\n\n";
						
						$message_body_html_tmp .= "<li><a href=\"" . $b_url . "\">" . $i['blog_title'] . "</a> (" . $comment_count . ")<br />";
						$message_body_html_tmp .= "<i>" . $i['blog_synopsis'] . "</i><br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_rsp_blog'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_rsp_blog'] . "</b><br /><ul>";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</ul></p>";
				}
				
				
				
				// GET SPLASH LATEST SUBJECTS ---------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$forum->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
				$forum->rsp_status_id = $c_node['rsp']['status']['live'];
				$forum->limit = 5;
				$rsp_subjects = $forum->selSubjects();
				unset($forum->rsp_level_id, $forum->rsp_status_id, $forum->limit);
				
				
				if (isset($rsp_subjects)) {
					foreach($rsp_subjects as $key => $i):
						//format url
						$b_url = $url . "frm_view.php?subject_id=" . $i['subject_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
						$comment_count = $comment->getCommentCount($i['subject_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['subject_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $i['subject_synopsis'] . "\n";
						$message_body_text_tmp .= $b_url . "\n\n";
						
						$message_body_html_tmp .= "<li><a href=\"" . $b_url . "\">" . $i['subject_title'] . "</a> (" . $comment_count . ")<br />";
						$message_body_html_tmp .= "<i>" . $i['subject_synopsis'] . "</i><br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_rsp_subject'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_rsp_subject'] . "</b><br /><ul>";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</ul></p>";
				}
				
				
				
				// GET SPLASH LATEST LIBRARY ---------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
				$library->rsp_status_id = $c_node['rsp']['status']['live'];
				$library->limit = 5;
				$rsp_librarys = $library->selLibraryItems();
				unset($library->rsp_level_id, $library->rsp_status_id, $library->limit);
				
				
				if (isset($rsp_librarys)) {
					foreach($rsp_librarys as $key => $i):
						//format url
						$b_url = $url . "lib_view.php?library_id=" . $i['library_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
						$comment_count = $comment->getCommentCount($i['library_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['library_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $i['library_synopsis'] . "\n";
						$message_body_text_tmp .= $b_url . "\n\n";
						
						$message_body_html_tmp .= "<li><a href=\"" . $b_url . "\">" . $i['library_title'] . "</a> (" . $comment_count . ")<br />";
						$message_body_html_tmp .= "<i>" . $i['library_synopsis'] . "</i><br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_rsp_library'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_rsp_library'] . "</b><br /><ul>";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</ul></p>";
				}
				
				
				
				// GET SPLASH LATEST SCHEDULES --------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
				$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
				$schedule->limit = 5;
				$rsp_schedules = $schedule->selScheduleItems();
				unset($schedule->rsp_level_id, $schedule->rsp_status_id, $schedule->limit);
				
				
				if (isset($rsp_schedules)) {
					foreach($rsp_schedules as $key => $i):
						//format url
						$b_url = $url . "sch_view.php?schedule_id=" . $i['schedule_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
						$comment_count = $comment->getCommentCount($i['schedule_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['schedule_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $i['schedule_synopsis'] . "\n";
						$message_body_text_tmp .= $b_url . "\n\n";
						
						$message_body_html_tmp .= "<li><a href=\"" . $b_url . "\">" . $i['schedule_title'] . "</a> (" . $comment_count . ")<br />";
						$message_body_html_tmp .= "<i>" . $i['schedule_synopsis'] . "</i><br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_rsp_schedule'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_rsp_schedule'] . "</b><br /><ul>";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</ul></p>";
				}
				
				
				
				// GET SPLASH LATEST POLLS ---------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
				$poll->rsp_status_id = $c_node['rsp']['status']['live'];
				$poll->limit = 5;
				$rsp_polls = $poll->selPolls();
				unset($poll->rsp_level_id, $poll->rsp_status_id, $poll->limit);
				
				
				if (isset($rsp_polls)) {
					foreach($rsp_polls as $key => $i):
						//format url
						$b_url = $url . "pol_view.php?poll_id=" . $i['poll_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
						$comment_count = $comment->getCommentCount($i['poll_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['poll_question'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $b_url . "\n\n";
						
						$message_body_html_tmp .= "<li><a href=\"" . $b_url . "\">" . $i['poll_question'] . "</a> (" . $comment_count . ")<br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_rsp_poll'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_rsp_poll'] . "</b><br /><ul>";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</ul></p>";
				}
				
				
				
				$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
				$bookmark->user_id = $result->fields['user_id'];
				
				
				// GET BOOKMARKED BLOG --------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
				$watched_blog_ids = $bookmark->getBookmarks();
				
				if (!empty($watched_blog_ids)) {
					$blog->blog_ids = $watched_blog_ids;
					$bookmark_blogs = $blog->selBlogs();
				}
				
				if (isset($bookmark_blogs)) {
					foreach($bookmark_blogs as $key => $i):
						//format url
						$b_url = $url . "blg_view.php?blog_id=" . $i['blog_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
						
						
						
						
						$comment_count = $comment->getCommentCount($i['blog_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['blog_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $b_url . "\n";
						
						$message_body_html_tmp .= "<a href=\"" . $b_url . "\">" . $i['blog_title'] . "</a> (" . $comment_count . ")<br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_bookmark_blog'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_bookmark_blog'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				
				// GET BOOKMARKED SUBJECT -----------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
				$watched_subject_ids = $bookmark->getBookmarks();
				
				if (!empty($watched_subject_ids)) {
					$forum->subject_ids = $watched_subject_ids;
					$bookmark_subjects = $forum->selSubjects();
				}
				
				if (isset($bookmark_subjects)) {
					foreach($bookmark_subjects as $key => $i):
						//format url
						$f_url = $url . "frm_view.php?subject_id=" . $i['subject_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
						
						
						
						
						$comment_count = $comment->getCommentCount($i['subject_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['subject_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $f_url . "\n";
						
						$message_body_html_tmp .= "<a href=\"" . $f_url . "\">" . $i['subject_title'] . "</a> (" . $comment_count . ")<br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_bookmark_subject'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_bookmark_subject'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				
				// GET BOOKMARKED LIBRARY -----------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
				$watched_library_ids = $bookmark->getBookmarks();
				
				if (!empty($watched_library_ids)) {
					$library->library_ids = $watched_library_ids;
					$bookmark_librarys = $library->selLibraryItems();
				}
				
				if (isset($bookmark_librarys)) {
					foreach($bookmark_librarys as $key => $i):
						//format url
						$l_url = $url . "lib_view.php?library_id=" . $i['library_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
						
						
						$comment_count = $comment->getCommentCount($i['library_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['library_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $l_url . "\n";
						
						$message_body_html_tmp .= "<a href=\"" . $l_url . "\">" . $i['library_title'] . "</a> (" . $comment_count . ")<br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_bookmark_library'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_bookmark_library'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				
				// GET BOOKMARKED SCHEDULE -----------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
				$watched_schedule_ids = $bookmark->getBookmarks();
				
				if (!empty($watched_schedule_ids)) {
					$schedule->schedule_ids = $watched_schedule_ids;
					$bookmark_schedules = $schedule->selScheduleItems();
				}
				
				if (isset($bookmark_schedules)) {
					foreach($bookmark_schedules as $key => $i):
						//format url
						$s_url = $url . "sch_view.php?schedule_id=" . $i['schedule_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
						
						
						$comment_count = $comment->getCommentCount($i['schedule_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['schedule_title'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $s_url . "\n";
						
						$message_body_html_tmp .= "<a href=\"" . $s_url . "\">" . $i['schedule_title'] . "</a> (" . $comment_count . ")<br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_bookmark_schedule'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_bookmark_schedule'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				// GET BOOKMARKED POLLS --------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
				$watched_poll_ids = $bookmark->getBookmarks();
				
				if (!empty($watched_poll_ids)) {
					$poll->poll_ids = $watched_poll_ids;
					$bookmark_polls = $poll->selPolls();
				}
				
				if (isset($bookmark_polls)) {
					foreach($bookmark_polls as $key => $i):
						//format url
						$p_url = $url . "pol_view.php?poll_id=" . $i['poll_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
						
						
						$comment_count = $comment->getCommentCount($i['poll_id'], $lastWeek);
						if (empty($comment_count)) {
							$comment_count = "0";
						}
		
						//format newsletter content
						$message_body_text_tmp .= $i['poll_question'] . " (" . $comment_count . ")\n";
						$message_body_text_tmp .= $p_url . "\n";
						
						$message_body_html_tmp .= "<a href=\"" . $p_url . "\">" . $i['poll_question'] . "</a> (" . $comment_count. ")<br />";
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_bookmark_poll'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_bookmark_poll'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				// GET PUBLISHED BLOGS ---------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				unset($blog->blog_ids);
				$blog->user_id = $result->fields['user_id'];
				$pub_blogs = $blog->selBlogs();
				
				if (isset($pub_blogs)) {
					foreach($pub_blogs as $key => $i):
						//format url
						$b_url = $url . "blg_view.php?blog_id=" . $i['blog_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
						
						$comment_count = $comment->getCommentCount($i['blog_id'], $lastWeek);
						
						if (!empty($comment_count) && $comment_count>0) {
							//format newsletter content
							$message_body_text_tmp .= $i['blog_title'] . " (" . $comment_count. ")\n";
							$message_body_text_tmp .= $b_url . "\n";
							
							$message_body_html_tmp .= "<a href=\"" . $b_url . "\">" . $i['blog_title'] . "</a> (" . $comment_count. ")<br />";
						}
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_pub_blog'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_pub_blog'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				// GET PUBLISHED SUBJECTS ------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				unset($forum->subject_ids);
				$forum->user_id = $result->fields['user_id'];
				$pub_subjects = $forum->selSubjects();
				
				if (isset($pub_subjects)) {
					foreach($pub_subjects as $key => $i):
						//format url
						$s_url = $url . "frm_view.php?subject_id=" . $i['subject_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
						
						$comment_count = $comment->getCommentCount($i['subject_id'], $lastWeek);
						
						if (!empty($comment_count) && $comment_count>0) {
							//format newsletter content
							$message_body_text_tmp .= $i['subject_title'] . " (" . $comment_count. ")\n";
							$message_body_text_tmp .= $s_url . "\n";
							
							$message_body_html_tmp .= "<a href=\"" . $s_url . "\">" . $i['subject_title'] . "</a> (" . $comment_count. ")<br />";
						}
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_pub_subject'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_pub_subject'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				
				// GET PUBLISHED LIBRARY ------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				unset($library->library_ids);
				$forum->user_id = $result->fields['user_id'];
				$pub_librarys = $library->selLibraryItems();
				
				if (isset($pub_librarys)) {
					foreach($pub_librarys as $key => $i):
						//format url
						$s_url = $url . "lib_view.php?library_id=" . $i['library_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
						
						$comment_count = $comment->getCommentCount($i['library_id'], $lastWeek);
						
						if (!empty($comment_count) && $comment_count>0) {
							//format newsletter content
							$message_body_text_tmp .= $i['library_title'] . " (" . $comment_count . ")\n";
							$message_body_text_tmp .= $s_url . "\n";
							
							$message_body_html_tmp .= "<a href=\"" . $s_url . "\">" . $i['library_title'] . "</a> (" . $comment_count . ")<br />";
						}
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_pub_library'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_pub_library'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				// GET PUBLISHED SCHEDULE ------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				unset($schedule->schedule_ids);
				$schedule->user_id = $result->fields['user_id'];
				$pub_schedules = $schedule->selScheduleItems();
				
				if (isset($pub_schedules)) {
					foreach($pub_schedules as $key => $i):
						//format url
						$s_url = $url . "sch_view.php?schedule_id=" . $i['schedule_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
						
						$comment_count = $comment->getCommentCount($i['schedule_id'], $lastWeek);
						
						if (!empty($comment_count) && $comment_count>0) {
							//format newsletter content
							$message_body_text_tmp .= $i['schedule_title'] . " (" . $comment_count . ")\n";
							$message_body_text_tmp .= $s_url . "\n";
							
							$message_body_html_tmp .= "<a href=\"" . $s_url . "\">" . $i['schedule_title'] . "</a> (" . $comment_count . ")<br />";
						}
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_pub_schedule'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_pub_schedule'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				// GET PUBLISHED POLLS ---------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				unset($poll->poll_ids);
				$poll->user_id = $result->fields['user_id'];
				$pub_polls = $poll->selPolls();
				
				if (isset($pub_polls)) {
					
					foreach($pub_polls as $key => $i):
						//format url
						$s_url = $url . "pol_view.php?poll_id=" . $i['poll_id'];
						
						//get the comment count
						$comment->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
						
						$comment_count = $comment->getCommentCount($i['poll_id'], $lastWeek);
						
						if (!empty($comment_count) && $comment_count>0) {
							//format newsletter content
							$message_body_text_tmp .= $i['poll_question'] . " (" . $comment_count. ")\n";
							$message_body_text_tmp .= $s_url . "\n";
							
							$message_body_html_tmp .= "<a href=\"" . $s_url . "\"><b>" . $i['poll_question'] . "</a> " . $comment_count . ")<br />";
						}
					endforeach;
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_pub_poll'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_pub_poll'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				// GET STATISTICS --------------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$statistic->section_item_id = $result->fields['user_id'];
				$statistic->user_id = $result->fields['user_id'];
				$user_statistic = $statistic->getStatistics();
				
				if (isset($user_statistic)) {
					$message_body_html_tmp .= "<table border=0 cellspacing=2 cellpadding=2>";
					
					foreach($user_statistic as $key => $i):
						if (isset($lang['arr_user_statistic_type_id'][$i['statistic_type_id']])) {
							$message_body_text_tmp .= $lang['arr_user_statistic_type_id'][$i['statistic_type_id']] . " (" . $i['total'] . ")\n";
							
							$message_body_html_tmp .= "<tr><td>" . $lang['arr_user_statistic_type_id'][$i['statistic_type_id']] . "</td><td>" . $i['total'] . "</td></tr>";
						}
					endforeach;
					
					$message_body_html_tmp .= "</table>";
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_statistics'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_statistics'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				
				// GET NETWORK -----------------------------------------------------
				$message_body_text_tmp = "";
				$message_body_html_tmp = "";
				
				$sn->user_id = $result->fields['user_id'];
				$sn->createNetwork();
				$user_network = $sn->getSocialNetworkSummary();
				$network_relations = $sn->getPendingRelations();
				if (!empty($network_relations)) {
					$user_outstanding_invites = count($network_relations);
				}
				else {
					$user_outstanding_invites = 0;
				}
				
				if (isset($user_network)) {
					$message_body_html_tmp .= "<table border=0 cellspacing=2 cellpadding=2>";
					
					$total = 0;
					
					foreach($user_network as $key => $i):
						if (isset($lang['sn']['degree'][$i['degree_id']])) {
							$sub_total = 0;
							if (isset($i['sn_total']) && $i['sn_total'] > 0) {
								$sub_total = $i['sn_total'];
							}
							
							$message_body_text_tmp .= $lang['sn']['degree'][$i['degree_id']] . " (" . $sub_total . ")\n";
							
							$message_body_html_tmp .= "<tr><td>" . $lang['sn']['degree'][$i['degree_id']] . "</td><td>" . $sub_total . "</td></tr>";
						
							$total = $total+$sub_total;
						}
					endforeach;
					
					$sub_total = 0;
					if (isset($outstanding_invites) && $outstanding_invites > 0) {
						$sub_total = $outstanding_invites;
					}
								
					$message_body_text_tmp .= $lang['txt_outstanding_invites'] . " (" . $sub_total . ")\n";
							
					$message_body_html_tmp .= "<tr><td>" . $lang['txt_outstanding_invites'] . "</td><td>" . $sub_total . "</td></tr>";
					
					$total = $total+$sub_total;
					
					$message_body_text_tmp .= $lang['txt_your_social_network'] . " (" . $total . ")\n";
							
					$message_body_html_tmp .= "<tr><td>" . $lang['txt_your_social_network'] . "</td><td>" . $total . "</td></tr>";
					
					$message_body_html_tmp .= "</table>";
				}
				
				if (!empty($message_body_text_tmp)) {
					$message_body_text .= "\n" . $lang['hdr_network'] . "\n";
					$message_body_text .= $message_body_text_tmp . "\n";
					$message_body_text .= "\n";
					
					$message_body_html .= "<p><b>" . $lang['hdr_network'] . "</b><br />";
					$message_body_html .= $message_body_html_tmp . "<br />";
					$message_body_html .= "</p>";
				}
				
				
				
				// OUTRO -----------------------------------------------------------
				$message_body_text .= "\n\n" . $lang['txt_outro'] . "\n\n" . $url . "\n";
				$message_body_html .= "<p>" . $lang['txt_outro'] . "<br /><br /><a href=\"" . $url . "\">" . $url . "</a><br /></p>";
				
				
				
				// HTML-version of the mail
				$html  = "<HTML><HEAD><TITLE></TITLE></HEAD>";
				$html .= "<BODY>";
				$html .= utf8_decode($message_body_html);
				$html .= "</BODY></HTML>";
				
				//format message
				if (empty($result->fields['user_firstname'])) {
					$result->fields['user_firstname'] = "";
				}
				
				$mail->Body = $html;
				// non - HTML-version of the email
				$mail->AltBody   = utf8_decode($message_body_text);
				
				// add new email-address to mailer-object
				$mail->AddAddress($result->fields['user_email'], $result->fields['user_firstname']);
			
				// Send email
				if(!$mail->Send()) {
					$log = "There has been a mail error sending newsletter (subject:" . $mail->Subject . ")to " . $result->fields['user_email'] . "," . $result->fields['user_firstname'] . ".";
				}
				
				//write to log file
				if (isset($GLOBALS['am_log']) && $GLOBALS['am_log'] == true) {
					if (!isset($log)) {
						$log = "digest newsletter (subject:" . $mail->Subject . ") to " . $result->fields['user_email'] . "," . $result->fields['user_firstname'] . " sent.";
					}
					writeLogFile($log);
				}
				
				// Clear all addresses for next loop
				$mail->ClearAddresses();
				unset($log);
				
				$end_user_id = $result->fields['user_id'];
				
				$result->MoveNext();
			}
			
			// we update the newsletter table
			$rec = array();
			
			$status_id = 1; //processing
					
			if (count($result->fields) < $c_node['newsletter']['nr_per_batch']) {
				$status_id = 2; //completed
			}
			
			$rec['status_id'] = $status_id;
			
			if (isset($end_user_id)) {
				$rec['start_user_id'] = $end_user_id;
			}
			
			$query = $db->GetUpdateSQL($nl_result, $rec, false, get_magic_quotes_gpc());
				
			$result = $db->Execute($query);
			
			$mail->SmtpClose(); // Manually close the SMTP connection
			
			$db->Close();
		}
	}
}
?>