<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<div class="col_left1">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_channels'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_channel_intro'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($group)) {
			?>
				<?php echo $lang['hdr_group_channels'];?><br />
			<?php
			}
			else {
			?>
				<?php echo $lang['hdr_my_channels'];?><br />
			<?php }?>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($my_channels)) {
				foreach($my_channels as $key => $i):
				?>
				<p>
					<a href="chl_view.php?channel_id=<?php echo $i['channel_id'];?>"><?php echo $i['channel_title'];?></a><br />
					<?php echo $i['channel_synopsis'];?><br />
				</p>
				<?php
				endforeach;
				}
				
				if (isset($group) && $this->group_acs->checkPermission($resource_ids['group']['channels'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
				?>
					<p align="right">
						<a href="chl_edit.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_add'];?></a><br />
					</p
				<?php
				}
				elseif (isset($me['user_id'])) {
				?>
					<p align="right">
						<a href="chl_edit.php"><?php echo $lang['href_add'];?></a><br />
					</p
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	
	<?php
	if (isset($channels)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_node_channels'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				foreach($channels as $key => $i):
				?>
				<p>
					<a href="chl_view.php?channel_id=<?php echo $i['channel_id'];?>"><?php echo $i['channel_title'];?></a><br />
					<?php echo $i['channel_synopsis'];?><br />
				</p>
				<?php
				endforeach;
				
				?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_channel'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($channel)) {
				?>
				<p>
					<b><?php echo $channel['channel_title'];?></b><br />
					<?php echo $channel['channel_synopsis'];?><br />
				</p>
				<?php
				if (isset($channel['feed'])) {
				?>
				<p>
					<?php
					if (!empty($channel['feed']['image_url'])) {// Show website logo (if presented)
						echo "<a href='" . $channel['feed']['image_link'] . "' target='_new'><img src='" . $channel['feed']['image_url'] . "' alt='" . $channel['feed']['image_title'] . "' vspace='1' border='0' /></a><br />";
					}
					
					// Show clickable website title
					if (!empty($channel['feed']['link'])) {
						echo "<b><a href='http://" . $channel['feed']['link'] . "' target='_new'>" . $channel['feed']['title'] . "</a></b><br />";
					}
					
					// Show website description
					if (!empty($channel['feed']['description'])) {
						echo $channel['feed']['description'] . "<br />";
					}
					?>
				</p>
				<?php
				if (!empty($channel['feed']['items'])) {
				foreach($channel['feed']['items'] as $item):
				?>
				<p>
					<?php
					echo "<a href='" . $item['link'] . "' target='_new'>".$item['title']."</a><br />";
					if (!empty($item['description'])) {
						echo $item['description']."<br />";
					}
					?>
				</p>
				<?php
				endforeach;
				}
				if ($channel['user_id'] == $me['user_id']) {
				?>
				<p align="right">
					<a href="chl_edit.php?channel_id=<?php echo $channel['channel_id'];?>" class="link_urgent"><?php echo $lang['href_edit_this'];?></a><br />
				</p>
				<?php }}?>
				<?php
				} else {
				?>
				<div class="content">
					<?php echo $lang['err_no_channels'];?><br />
				</div>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>