<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

$menu_section = "splash";

if (!empty($_REQUEST['http_referer'])) {
    $http_referer = $_REQUEST['http_referer'];
}

//set up user
require_once('class/User.class.php');
$user = new User($db, $date);
$user->status_ids = $c_node['user']['status'];


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');


//form actions
if (isset($_POST['update_user_homepage'])) {
	if (!empty($_POST['user_homepage'])) {
		$user_homepage = "my_view.php";
	}
	else {
		$user_homepage = "spl_view.php";
	}
	
	$query = "
		SELECT user_id, user_homepage FROM " . $db->prefix . "_user 
		WHERE 
		user_id=" . $me['user_id']
	;
	
	$result = $db->Execute($query);
	
	$rec = array();
	$rec['user_homepage'] = $user_homepage;
	
	$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
	$_SESSION['user_homepage'] = $user_homepage;
}
elseif (isset($_POST['login'])) {

	if (isset($_POST['email']) && $_POST['email'] && isset($_POST['password']) && $_POST['password']) {
		$user->relation_type = $c_node['user']['relation_type']['approved'];

		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, null);
		$user->statistic = $statistic;
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];

		$user->checkLogin($_REQUEST['email'],$_REQUEST['password']);
		
		if (empty($GLOBALS['am_error_log'])) {
			//setup relations
			require_once('class/SocialNetwork.class.php');
			$sn = new SocialNetwork(null, $db, null);
			$sn->relation_type_ids = $c_node['user']['relation_type'];
			$sn->status_ids = $c_node['user']['status'];
			$user->sn = $sn;
			
			if (isset($http_referer)) {
			    $user->http_referer = $http_referer;
			}
			$user->loginUser($_REQUEST['email'],$_REQUEST['password']);

		}
	}
	else {
		$GLOBALS['am_error_log'][] = array(20, null, null);
	}

}
elseif (isset($_REQUEST['registration_complete'])) {
	$display = "registration_complete";
}
elseif (isset($_REQUEST['man'])) {
	
	require_once($languageArrayPath . 'arr_man.lang.php');
	
	//wiki
	require_once('class/Wiki/Wiki.php');
	$wiki =& new Text_Wiki();
	$wiki->disableRule('wikilink');
	
	if (isset($_REQUEST['man_id']) && $_REQUEST['man_id'] > 0) {
		$page = $_REQUEST['man_id'];
	}
	else {
		$page = 0;
	}
	
	$langfile = $lang['man'][$page][0] . ".man.php";
	$output_manual_page['man'] = readTxtFile($languagePath . 'man/' . $langfile);
	$output_manual_page['man'] = stripslashes($output_manual_page['man']);
	$output_manual_page['man'] = $wiki->transform($output_manual_page['man'], 'Xhtml');
	$output_manual_page['title'] = $lang['man'][$page][1];
	$output_manual_page['man_id'] = $page;
	$display = "man";
}
elseif (isset($_REQUEST['dormant'])) {
	// the user has set their account to be dormant
	// they can type in their email and dob to re-active the account.
	// They will be sent a new password.
	$display = "dormant";
}
elseif (isset($_POST['activate'])) {
	// the user has set their account to be dormant. We will check user_id and
	// dob, if correct we set status_id to active and log them in
	// Checks the email and the password
	require_once('class/UserAdmin.class.php');
	$user = new UserAdmin($db, $date);

	$catpcha = strtoupper($_POST['captchastring']);
	
	if (empty($catpcha) || empty($_SESSION['CAPTCHAString']) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['am_error_log'][] = array(36, null, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

		$query = "
			SELECT u.user_id, u.user_firstname, u.user_email
			FROM " . $db->prefix . "_user u
			WHERE 
			u.user_email=" . $db->qstr($frmdata['email'], get_magic_quotes_gpc()) . " AND 
			u.status_id=" . $c_node['user']['status']['dormant'] . " AND
			u.user_dob=" . $db->qstr($dob, get_magic_quotes_gpc())
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;
			
			$updatequery = "
				UPDATE " . $db->prefix . "_user SET 
				status_id=" . $c_node['user']['status']['active'] . "
				WHERE
				user_id=" . $temp['user_id']
			;
			
			$db->Execute($updatequery);
				
			//update the password and send email
			$password = $user->createPassword();
			$user->savePassword($password, $temp['user_email']);
			
			//get file to send
			$body_file_txt = readTxtFile($languageTextPath . "send_new_password.txt.php");
			
			$body_file_txt = str_replace("SYS_KEYWORD_NAME", $temp['user_firstname'], $body_file_txt);
			$body_file_txt = str_replace("SYS_KEYWORD_PASSWORD", $password, $body_file_txt);
			
			//create URL
			$url = "http://" . $_SERVER['HTTP_HOST'];
			$url .= dirname ($_SERVER['PHP_SELF']);
			//sometimes the server adds / as the last characture - we need to check.
			if (substr($url, -1, 1) != "/") {
			    $url .= "/";
			}
			
			$body_file_txt = str_replace("SYS_KEYWORD_URL", $url, $body_file_txt);
			
	
			//setup mail
			require_once('class//Mail/class.phpmailer.php');
			$mail = new PHPMailer();
			$mail->Host = 		$c_node['mail']['host'];
			$mail->Port = 		$c_node['mail']['port'];
			$mail->Mailer = 	$c_node['mail']['mailer'];
			
			if (isset($c_node['mail']['smtp']['username'])) {
				$mail->SMTPAuth = true;
				$mail->Username = $c_node['mail']['smtp']['username'];
				$mail->Password = $c_node['mail']['smtp']['password'];
			}
			
			$mail->From = 		$c_node['mail']['no_reply_address'];
			$mail->FromName = 	$c_node['mail']['from_name'];
			$mail->WordWrap = 	$c_node['mail']['wordwrap'];
			$mail->Subject = 	$lang['txt_email_subject_activate'];
			$mail->AddAddress($temp['user_email'], $temp['user_firstname']);
			$mail->Body = $body_file_txt;
			
			
			if(!$mail->Send()) {
				$GLOBALS['am_error_log'][] = array(23, 1, $mail->ErrorInfo);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(22, null, null); // email - dob mismatch
		}
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: index.php");
		exit;
	}
	
	$display = "dormant";
}

if (!empty($display)) {
	$body->set('display', $display);
}


if (!empty($output_manual_page)) {
	$body->set('manual_page', $output_manual_page);
}

if (isset($display) && $display=="dormant") {
	$body->set('datedropdown', $date->dateDropdown());
}

include "inc/footer.inc.php";

?>
