<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<?php
	if (isset($display) && $display == "result") {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_results'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_result_text'];?><br />
				</p>
				
				<?php
				if (isset($quiz['quiz_display_answers'])) {
				?>
				<p>
					<?php
					if (isset($quiz['questions'])) {
					?>
					<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($quiz['questions'] as $key => $q):
					?>
					<tr>
						<td colspan="3">
							<b><?php echo $q['question_body'];?></b>
						</td>
					</tr>
					
					<?php
					if (isset($q['options'])) {
					foreach($q['options'] as $key1 => $i):
					?>
					<tr>
						<td width="1" nowrap="nowrap">
							&nbsp;&nbsp;&nbsp;<?php echo $key1+1;?>.<br />
						</td>
						<td>
							<?php echo $i['option_body'];?><br />
						</td>
						<td align="right">
							<?php
							if ($i['option_id'] == $q['question_correct_option_id']) {
								echo $lang['txt_right_answer'];
							}
							?><br />
						</td>
						<td align="right">
							<?php
							if ($i['option_id'] == $quiz['answers'][$i['question_id']]) {
								echo "&nbsp;(" . $lang['txt_chosen_answer'] . ")";
							}
							?><br />
						</td>
					</tr>
					<?php
					endforeach;
					}
					?>
					<tr>
						<td>
							<br />
						</td>
						<td colspan="3">
							<b><?php
							if ($quiz['answers'][$i['question_id']] == $q['question_correct_option_id']) {
								echo $lang['txt_answer_right'];
							}
							else {
								echo $lang['txt_answer_wrong'];
							}
							?></b>
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<br />
						</td>
						<td colspan="3">
							<?php echo $q['question_answer'];?><br />
						</td>
					</tr>
					
					<?php
					endforeach;
					?>
					</table>
					<?php }?>
				</p>
				<?php }?>
				
				<p>
					<?php
					if (isset($quiz['passed'])) {
						echo $quiz['quiz_body_exit_pass'];
					}
					else {
						echo $quiz['quiz_body_exit_fail'];
					}
					?><br />
				</p>
				
				<p>
					<i><?php echo $lang['txt_retake'];?></i><br />
				</p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	
	<?php
	}
	elseif (isset($display) && $display == "quiz") {
	?>
	<form action="quz_view.php" method="post" name="frm" id="id_frm">
	<input type="hidden" name="quiz_id" value="<?php if(isset($quiz['quiz_id'])) { echo $quiz['quiz_id'];}?>" />
	<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];} elseif (isset($quiz['group_id'])) { echo $quiz['group_id'];}?>" />
	
	<div class="box">
		<div class="box_top">
			<?php echo $quiz['quiz_title'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $quiz['quiz_body_intro_display'];?><br />
				</p>
				
				<?php
				if (isset($quiz['questions'])) {
				?>
				<table border="0" cellspacing="0" cellpadding="4">
				<?php
				foreach($quiz['questions'] as $key => $q):
				?>
				<tr>
					<td colspan="3">
						<b><?php echo $q['question_body'];?></b>
					</td>
				</tr>
				
				<?php
				if (isset($q['options'])) {
				foreach($q['options'] as $key1 => $i):
					$checked = "";
					if (isset($quiz['answers'][$i['question_id']]) && $i['option_id'] == $quiz['answers'][$i['question_id']]) {
						$checked = "checked=\"checked\"";
					}
				?>
				<tr>
					<td width="1" nowrap="nowrap">
						&nbsp;&nbsp;&nbsp;<?php echo $key1+1;?>.<br />
					</td>
					<td>
						<?php echo $i['option_body'];?><br />
					</td>
					<td align="right">
						<input type="radio" class="input_right" name="answers[<?php echo $q['question_id'];?>]" value="<?php if (isset($i['option_id'])) { echo $i['option_id'];}?>" <?php echo $checked;?> /><br />
					</td>
				</tr>
				<?php
				endforeach;
				}
				?>
				
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
				
				<form action="quz_view.php" method="post" name="frm" id="id_frm">
				<input type="hidden" name="quiz_id" value="<?php if(isset($quiz['quiz_id'])) { echo $quiz['quiz_id'];}?>" />
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];} elseif (isset($quiz['group_id'])) { echo $quiz['group_id'];}?>" />
				
				<p align="right">
					<input type="submit" class="input_submit" name="submit_quiz" value="<?php echo $lang['sub_submit_quiz'];?>" /><br />
				</p>
				</form>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	</form>
	<?php
	}
	elseif (isset($quiz)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_quiz'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<div class="metadata_top">
					<b><?php echo $lang['txt_item_options'];?></b> -&#62; 
					<?php
					if (isset($me['user_id']) && $me['user_id'] > 0) { // we need to be logged in
					?>
					
					<?php
					if ($me['user_id'] == $quiz['user_id'] && !empty($quiz['quiz_allow_edit'])) {
					?>
					<a href="quz_edit.php?quiz_id=<?php echo $quiz['quiz_id'];?>"><?php echo $lang['href_edit'];?></a>
					,&nbsp;
					<?php }?>
					
					<?php
					if ($me['user_id'] == $quiz['user_id']) {
					?>
					<a href="quz_view.php?quiz_id=<?php echo $quiz['quiz_id'];?>&amp;stats=1"><?php echo $lang['href_stats'];?></a>
					,&nbsp;
					<?php }?>
					
					<?php
					if (isset($quiz['bookmark']['watch'])) {
					?>
					<a href="quz_view.php?quiz_id=<?php echo $quiz['quiz_id'];?>&amp;bookmark=del_mark"><?php echo $lang['href_unwatch_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="quz_view.php?quiz_id=<?php echo $quiz['quiz_id'];?>&amp;bookmark=ins_mark"><?php echo $lang['href_watch_this'];?></a>
					<?php }?>
					,&nbsp;
					
					<?php
					if (isset($quiz['bookmark']['recommend'])) {
					?>
					<a href="quz_view.php?quiz_id=<?php echo $quiz['quiz_id'];?>&amp;bookmark=del_tip"><?php echo $lang['href_unrecommend_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="quz_view.php?quiz_id=<?php echo $quiz['quiz_id'];?>&amp;bookmark=ins_tip"><?php echo $lang['href_recommend_this'];?></a>
					<?php }?>
					
					<?php
					if (!isset($quiz['bookmark']['watch']) && isset($batch_enabled) && $batch_enabled == true) {
					?>
					,&nbsp;
					<a href="quz_view.php?quiz_id=<?php echo $quiz['quiz_id'];?>&amp;bookmark=ins_mark&amp;notify=1"><?php echo $lang['href_watch_this_notify'];?></a>
					<?php }?>
					<?php }?>
					<br />
				</div>
				
				<p class="txt_item_title">
					<?php echo $quiz['quiz_title'];?><br />
				</p>
				
				<p>
					<?php echo $quiz['quiz_body_intro_display'];?><br />
				</p>
				
				<form action="quz_view.php" method="post" name="frm" id="id_frm">
				<input type="hidden" name="quiz_id" value="<?php if(isset($quiz['quiz_id'])) { echo $quiz['quiz_id'];}?>" />
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];} elseif (isset($quiz['group_id'])) { echo $quiz['group_id'];}?>" />
				
				<p align="right">
					<input type="submit" class="input_submit" name="take_quiz" value="<?php echo $lang['sub_take_quiz'];?>" /><br />
				</p>
				</form>
				
				<?php
				if (!empty($quiz['results'])) {
				?>
				<p>
						<b><?php echo $lang['hdr_my_results'];?></b><br />
						<?php
						$separator = ", ";
						foreach($quiz['results'] as $key => $r):
							if ($key == (count($quiz['results'])-1)) {
								$separator=".";
							}
							
							echo $r['result_mark'] . " (" . $this->date->formatDate($r['result_create_datetime'], 1) . ")" . $separator;
						endforeach;
						?>
					</td>
				</tr>
				<?php }?>
				
				<div class="metadata">
					<?php
					if (isset($author)) {
						if (isset($group)) {
							$profile_url = "grp_membership.php?group_id=" . $group['group_id'] . "&amp;user_id=" . $author['user_id'];
						}
						else {
							$profile_url = "sn_profile.php?user_id=" . $author['user_id'];
						}
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="<?php echo $profile_url;?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<?php
							if (isset($group)) {
							?>
							&nbsp;<?php echo $lang['txt_group_link'];?>: <a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $group['group_title'];?></a>
							<?php }?>
							<br />
						</p>
						
						<p>
							<b><?php echo $lang['hdr_quiz'];?></b> -&#62; 
							<?php
							if (!empty($quiz['bookmark'])) {
								echo $lang['txt_bookmarks'] . ": ";
								
								if (!empty($quiz['bookmark']['watch'])) {
									echo $lang['txt_marked'];
								}
				
								if (!empty($quiz['bookmark']['recommend'])) {
									echo $lang['txt_tipped'];
								}
								echo ", ";
							}
							?>
							<?php
							if ($quiz['quiz_create_datetime'] != $quiz['quiz_edit_datetime'] && !empty($quiz['quiz_edit_datetime'])) {
								echo $lang['txt_last_edited'] . ": ";
								echo $this->date->formatDate($quiz['quiz_edit_datetime'], 1) . ", ";
							}
							?>
							<?php echo $lang['txt_published_to'];?>: 
							<?php
							if (isset($quiz['rsp'])) {
								foreach($quiz['rsp'] as $key => $i):
									if (!empty($i['degree_id']) && $i['level_id'] == $rspconfig['rsp_level']['node']) {
									echo $lang['rsp']['rsp_level_degree'][$i['degree_id']];
								}
								else {
									echo trim($lang['rsp']['rsp_level'][$i['level_id']]);
								}
								echo " (" .$lang['rsp']['status'][$i['status_id']];
								
								if (!empty($i['rsp_featured'])) {
									echo " &amp; " .  $lang['txt_featured'];
								}
								
								echo ")";
								if ($key+1 < count($quiz['rsp'])) {
									echo ", ";
								}
								endforeach;
							}
							?>
							<br />
						</p>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (!empty($quiz['quiz_allow_comments'])) {
					$unlocked = 1;
				}
				
				$hidden_form = array(
					"quiz_id" => $quiz['quiz_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				
				if (isset($group['group_id'])) {
					$hidden_form['group_id'] = $group['group_id'];
				}
				
				if (isset($quiz['user_id'])) {
					$hidden_form['item_user_id'] = $quiz['user_id'];
				}
				
				$comment_url = "quz_view.php?quiz_id=" . $quiz['quiz_id'];
				
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($quizzes)) { //list view
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_quizzes'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
				?>
				<p>
					<?php echo $lang['txt_intro'];?><br />
				</p>
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					$display_items = trimArray($quizzes);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="quz_view.php?quiz_id=<?php echo $i['quiz_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="quz_view.php?quiz_id=<?php echo $i['quiz_id'];?>"><?php echo $this->date->formatDate($i['quiz_create_datetime'], 1);?></a><br />
						</td>
						<td valign="top">
							<?php echo $i['quiz_title'];?><br />
						</td>
						<td valign="top" align="right">
							<?php
							if (!empty($i['result']['result_mark'])) {
							?>
							<?php echo $lang['txt_results'];?>&nbsp;(<?php echo $i['result']['result_mark'];?>)
							<?php
							}
							else {
							?>
							<?php echo $lang['txt_not_taken'];?>
							<?php }?>
							<br />
						</td>
					</tr>
					<tr>
						<td colspan="3">
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($quizzes);
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	elseif (isset($my_group_quizzes)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_group_quizzes'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_intro_group'];?><br />
				
				<?php
				if (!empty($my_group_quizzes)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_group_quizzes as $key => $g):
					if (!empty($g['quizzes'])) {
					?>
					<tr>
						<td colspan="2">
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right" nowrap="nowrap">
							<a href="quz_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_quiz'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['quizzes'] as $key => $i):
					$quiz_url = "quz_view.php?quiz_id=" . $i['quiz_id'];
					?>
					<tr>
						<td>
							<b><?php echo $i['quiz_question'];?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<table width="360" cellpadding="0" cellspacing="20" border="0">
								<tr>
									<td class="picture">
									<?php
									$quiz = $i;
									
									include $templatePath . "quiz.inc.tpl.php";
									unset($quiz);
									?>
									</td>
								</tr>
							</table>
						</td>
				    </tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="3">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$group_no_quiz_list[] = $g;
					}
					endforeach;
					?>
					
				</table>
				<?php }?>
				
				<?php
				if (!empty($group_no_quiz_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_group'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($group_no_quiz_list as $key => $g):
					?>
					<tr>
						<td>
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right">
							<a href="quz_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_quiz'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($my_network_quizzes)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_network_quizzes'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_intro_network'];?><br />
				</p>
				
				<?php
				if (!empty($my_network_quizzes)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_network_quizzes as $key => $g):
					if (!empty($g['quizzes'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="quz_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_quiz'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['quizzes'] as $key => $i):
					$quiz_url = "quz_view.php?quiz_id=" . $i['quiz_id'];
					?>
					<tr>
						<td>
							<b><?php echo $i['quiz_question'];?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<table width="360" cellpadding="0" cellspacing="20" border="0">
								<tr>
									<td class="picture">
									<?php
									$quiz = $i;
									
									include $templatePath . "quiz.inc.tpl.php";
									unset($quiz);
									?>
									</td>
								</tr>
							</table>
						</td>
				    </tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$network_no_quiz_list[] = $g;
					}
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (!empty($network_no_quiz_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_network'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($network_no_quiz_list as $key => $g):
					?>
					<tr>
						<td colspan="2">
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right" colspan="2">
							<a href="quz_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_quiz'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($recommended_quizzes)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_quizzes'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
					echo "<p>" . $lang['txt_intro'] . "<br /></p>";
				}
				?>
				
				<?php
				if (!empty($recommended_quizzes)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($recommended_quizzes as $key => $g):
					if (!empty($g['quizzes'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="quz_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_quiz'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['quizzes'] as $key => $i):
					?>
					<tr>
						<td width="32" rowspan="2">
							<a href="quz_view.php?quiz_id=<?php echo $i['quiz_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="quz_view.php?quiz_id=<?php echo $i['quiz_id'];?>"><?php echo $this->date->formatDate($i['quiz_create_datetime'], 1);?></a><br />
							<?php echo $i['quiz_title'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
						<td>
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					endforeach;
					?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	else  { //error - no quizzes
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_quizzes'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_quizzes'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<?php
	if (isset($quizzes) && isset ($profile)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_quiz_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $profile['profile_nic'];?></b><br />
				</p>
				
				<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" border="0" alt="<?php echo $profile['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($profile['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$profile['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($profile['profile_create_datetime']);?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($quizzes) && isset ($group)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_quiz_group_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
				</p>
				
				<?php
				if (isset($group['image']['file_id'])) {
				?>
				<img src="get_file.php?file=<?php echo $group['image']['file'];?>" border="0" alt="<?php echo $group['image']['file_title'];?>" /><br />
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_membership_status'];?><br />
						</td>
						<td>
							<?php echo $group['member']['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_language'];?><br />
						</td>
						<td>
							<?php
							if (isset($lang['arr_lang_name'][$group['language_id']])) {
								echo $lang['arr_lang_name'][$group['language_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_type'];?><br />
						</td>
						<td>
							<?php 
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden'];
							}
							
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_rec_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $lang['txt_age_from'] . " " . $group['group_from_age'];
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo $lang['txt_age_upto'] . " " . $group['group_to_age'];
							}
							else {
								echo $lang['txt_age_all'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
				
				<?php
				if (!empty($group['member']['role_visitor'])) {
				?>
				<p align="right">
					<b><a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_join'];?></a></b><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
				<?php echo $lang['hdr_options'];?><br />
			</div>
			
			<div class="box_mid">
				<div class="content">
					<p>
					<b><?php echo $lang['txt_view'];?></b><br />
				</p>
				
				<?php
				if (isset($view) && $view == "node") {
				?>
				<?php echo $lang['href_view_node'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=node"><?php echo $lang['href_view_node'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($me['user_id'])) {
				?>
				
				<?php
				if (isset($view) && $view == "my_network") {
				?>
				<?php echo $lang['href_view_network'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=my_network"><?php echo $lang['href_view_network'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_groups") {
				?>
				<?php echo $lang['href_view_my_groups'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=my_groups"><?php echo $lang['href_view_my_groups'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "results") {
				?>
				<?php echo $lang['href_results'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=results"><?php echo $lang['href_results'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_quizzes") {
				?>
				<?php echo $lang['href_my_quizzes'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=my_quizzes"><?php echo $lang['href_my_quizzes'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "marked_quizzes") {
				?>
				<?php echo $lang['href_marked'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=marked_quizzes"><?php echo $lang['href_marked'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "tipped_quizzes") {
				?>
				<?php echo $lang['href_tipped'];?><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?view=tipped_quizzes"><?php echo $lang['href_tipped'];?></a><br />
				<?php }?>
				
				<?php }?>
				<?php
				if (isset($quiz)) {
				if (isset($group)) {
				?>
				<a href="quz_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_list_group_quizzes'];?></a><br />
				<?php
				}
				else {
				?>
				<a href="quz_view.php?user_id=<?php echo $quiz['user_id'];?>"><?php echo $lang['href_list_quizzes'];?></a><br />
				<?php }}?>
				
				<?php
				if (isset($group) || isset($view) && $view == "my_quizzes") {
				?>
				<p>
					<b><?php echo $lang['txt_options'];?></b><br />
				</p>
				
					<?php
					if (isset($view) && $view == "my_quizzes" && $this->user_acs->checkPermission($resource_ids['node']['quiz'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<a href="quz_edit.php"><?php echo $lang['href_add_quiz'];?></a><br />
					<?php }?>
					
					<?php
					if (isset($group)) {
					if ($this->group_acs->checkPermission($resource_ids['group']['quiz'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<a href="quz_edit.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_group_add_quiz'];?></a><br />
					<?php }}?>
				<?php }?>
				
				
				<?php
				if (isset($quiz)) {
				?>
				<p>
					<b><?php echo $lang['hdr_tag'];?></b><br />
				</p>
				
				<p>
					<?php
					$tags = "";
					if (isset($item_tags)) {
						foreach ($item_tags as $key => $i):
							$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if (isset($me['user_id']) && $i['user_id'] == $me['user_id']) {
								$tags .= "*";
							}
							
							if (count($item_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
						echo $tags;
					}
					?>
				</p>
					
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['quiz'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= $i['tag_body'];
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
				}
				?>
				
				
				<form action="quz_view.php" method="post" name="frm_view" id="id_frm_view">
				<input type="hidden" name="quiz_id" value="<?php if(isset($quiz['quiz_id'])) { echo $quiz['quiz_id'];}?>" />
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
				
				
				<p>
					<input width="30" class="input" name="tags" value="<?php echo $tags;?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
				</p>
				
				</form>
				<?php }?>
				<?php }?>
				
				<p>
					<b><?php echo $lang['hdr_search'];?></b><br />
				</p>
				
				<form action="search.php" method="post" name="search" id="id_search">
				<input type="hidden" name="search_type" value="quiz" />
				
				<p>
					<input type="text" class="input" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
				
				</form>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
