<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// if we receive a module_id and an item_id we display the profile based upon that item
// otherwise if we are logged in we see the registered profile, else the public profile

// we receive an identity_id (me) and an identity_id_relation (them). 

if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

$menu_section= "me";

// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (!empty($core_config['module'])) {
	if(is_file("components/" . $suffix . "/inc/" . $suffix . "_profile.header.php")) {
		include_once("components/" . $suffix . "/inc/" . $suffix . "_profile.header.php");
	}
}
	
	
// INDENTITY
require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);
$file->core_config_module = $core_config['module'];
$file->module_id = 0; // core

$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file = $file;


$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);


if (empty($output_identity_relation)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}



require_once($language_path_core . 'inc/me_common.inc.php');
	
$item_id = $output_identity_relation['identity_id'];


if (!empty($output_participation)) {
	$output_identity = $user->selUserIdentity(null, $output_participation['identity_id'], 1);
}
else { // we are not participating in this item/module hence we get my registered card
	$user->identity_type = $core_config['user']['identity']['type']['registered'];
	$output_identity = $user->selUserIdentity($_SESSION['user_id'], null, 1);
}


if ($_SESSION['user_id'] != $output_identity_relation['user_id']) {
	// get and set tags ---------------------------------------------
	require_once('class/Tag.class.php');
	$tag = new Tag($db, null, $core_config['tag']['core']['network']);
	$tag->user_id = $_SESSION['user_id'];
	$tag->item_id = $_REQUEST['identity_id'];
	
	if (isset($_POST['insert_tag'])) {
		if (empty($_POST['tag_id'])) { // we insert
			$tag->insertTag($_POST['tag_body']);
		}
		elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
			$tag->deleteTag($_POST['tag_id']);
		}
		else { // we update tag
			$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
		}
	}
	elseif (isset($_POST['delete_tag'])) {
		$tag->deleteTag($_POST['tag_id']);
	}
	elseif (isset($_REQUEST['edit_tag'])) {
		$output_tag = $tag->selTag($_REQUEST['edit_tag']);
	
		if (!empty($output_tag)) {
			$body->set('tag', $output_tag);
		}
	}
	
	$output_tags = $tag->selTags();

	if (!empty($output_tags)) {
		$body->set('tags', $output_tags);
	}
	
	// Setup Tie -------------------------------------------------------------
	require_once ("class/Tie.class.php");
	$tie = new Tie($db, $core_config);
	$tie->count_weak = true;
	$tie->count_strong = true;
	$output_ties['strong'] = $tie->selStrongTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'outbound', 3);
	$output_ties['strong_weak'] = $tie->selStrongToWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 3);
	$output_ties['weak_strong'] = $tie->selWeakToStrongTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 3);
	$output_ties['weak_outbound'] = $tie->selWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'outbound', 3);
	$output_ties['weak_inbound'] = $tie->selWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'inbound', 3);
	
	$output_ties_common = $tie->selCommonTies($output_identity['identity_id'], $output_identity_relation['identity_id']);
	
	
	if (!empty($output_ties)) {
		$body->set('ties', $output_ties);
	}
	
	if (!empty($output_ties_common)) {
		foreach($output_ties_common['weak'] as $key => $i) {
			$output_ties_common['weak'][$key]['item'] = $tie->selItem($i['module_id'], $i['item_id']);
		}
		
		foreach($output_ties_common['strong'] as $key => $i) {
			$output_ties_common['strong'][$key]['item'] = $tie->selItem($i['module_id'], $i['item_id']);
		}
	
		$body->set('ties_common', $output_ties_common);
	}
}	

// get user statistics ---------------------------------------------------
require_once('class/Statistic.class.php');
$statistic = new Statistic($db, $core_config['statistic']);

if (isset($module_id)) {
	$statistic->module_id = $module_id;
}

if (isset($item_id)) {
	$statistic->item_id = $item_id;
}
$output_statistics['user'] = $statistic->selStatistics();

$body->set('statistics', $output_statistics);



$body->set('identity', $output_identity_relation);



require_once ("class/Testimonial.class.php");
$testimonial = new Testimonial($db);
$testimonial->identity_id = $output_identity_relation['identity_id'];
$testimonial->testifier_identity_id = $output_identity['identity_id'];

$output_testimonials = $testimonial->selTestimonials(true, 2, true);

if (isset($output_testimonials)) {
	$body->set('testimonials', $output_testimonials);
}


// GET THE INVITEE
if (!empty($output_identity_relation['invitee_user_id'])) {
	$output_invitee_identity = $user->selUserIdentity($output_identity_relation['invitee_user_id']);
	
	// get the invitee testimonial
	if (!empty($output_invitee_identity)) {
		$testimonial->user_id = $output_invitee_identity['user_id'];
		$output_testimonial = $testimonial->selTestimonials(false, 1);
		
		if (!empty($output_testimonial[0])) {
			$output_invitee_identity['testimonial'] = $output_testimonial[0];
		}
		
		$body->set('invitee_identity', $output_invitee_identity);
	}
}





// get metadata
$query = "
	SELECT 
	user_metadata 
	FROM 
	" . $db->prefix . "_user u, " . $db->prefix . "_user_preference up 
	WHERE 
	u.user_id=up.user_id AND 
	up.user_preference_id=" . $core_config['user']['preference']['allow_sn_search'] . " AND 
	u.user_id=" . $output_identity_relation['user_id']
;
			
$result = $db->Execute($query);
			
if (isset($result->fields)) {
	if (!empty($result->fields['user_metadata'])) {
		$user_metadata = explode(',', $result->fields['user_metadata']);
		sort($user_metadata);
		$body->set('user_metadata', $user_metadata);
	}
}



$output_blocked = array();
$body->set('blocked', $output_blocked);


if (isset($output_common_ties)) {
	$body->set('common_ties', $output_common_ties);
}
	
// MODULE FOOTER INCLUSION -----------------------------------------------
// We include any footer files for the modules
if (!empty($core_config['module'])) {
	if(is_file("components/" . $suffix . "/inc/" . $suffix . "_profile.footer.php")) {
		include_once("components/" . $suffix . "/inc/" . $suffix . "_profile.footer.php");
	}
}

?>