<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


// Total users and total users online ------------------------------------
$timestamp = $db->UserTimeStamp(mktime()-(60*15), "YmdHis"); //last 15 minutes
	
$query = "
	SELECT count(user_id) as total_online_users
	FROM " . $db->prefix . "_user
	WHERE active_time > " . $timestamp . " AND
	status_id=" . $core_config['user']['status']['active']
;
		
$result = $db->Execute($query);
	
if ($result->fields['total_online_users']) {
	$output_statistics['total_online_users'] = $result->fields['total_online_users'];
	$result->Close();
}
else {
	$output_statistics['total_online_users'] = "0";
}

$query = "
	SELECT count(user_id) as total_users
	FROM " . $db->prefix . "_user
	WHERE status_id=" . $core_config['user']['status']['active']
;
		
$result = $db->Execute($query);
	
if ($result->fields['total_users']) {
	$output_statistics['total_users'] = $result->fields['total_users'];
	$result->Close();
}
else {
	$output_statistics['total_users'] = "0";
}


$output_chart = array();

$output_chart['24_hour_activity']   = '0-chart_24_hour_activity.png'; 
$output_chart['people_by_location'] = '0-chart_people_by_location.png';
$output_chart['30_day_activity']    = '0-chart_30_day_activity.png'; 

if (!empty($output_chart)) {
	$body->set('charts', $output_chart);
}

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}


?>