<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// if we receive a module_id and an item_id we display the profile based upon that item
// otherwise if we are logged in we see the registered profile, else the public profile

// we receive an identity_id (me) and an identity_id_relation (them). 

if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

$menu_section= "me";


// FILE -----------------------------------
require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);

if (isset($core_config['module'])) {
	$file->core_config_module = $core_config['module'];
}

$file->module_id = 0; // core

$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file = $file;



// GET VIEWED IDENTITIY ----------------------------------------------
$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);

if (empty($output_identity_relation)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// GET MY IDENTITIY ----------------------------------------------
if (!empty($output_participation)) {
	$output_identity = $user->selUserIdentity(null, $output_participation['identity_id'], 1);
}
else { // we are not participating in this item/module hence we get my registered card
	$user->identity_type = $core_config['user']['identity']['type']['registered'];
	$output_identity = $user->selUserIdentity($_SESSION['user_id'], null, 1);
}





// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (empty($suffix)) {
	$suffix = "core";
}

if (is_file("components/" . $suffix . "/inc/" . $suffix . "_profile.header.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_profile.header.php");
}


// GET THEIR MATRIX ---------------------------------------
$output_common_ties = $tie->selCommonTies($output_identity_relation['identity_id'], $output_identity['identity_id']);
$output_common_ties['is_mutual'] = $tie->isMutual($output_identity_relation['identity_id'], $output_identity['identity_id']);
$output_common_ties['identity_id'] = $output_identity['identity_id'];
$output_common_ties['identity_id_relation'] = $output_identity_relation['identity_id'];

$body->set('common_ties', $output_common_ties);




// GET THEIR RESPECTED NETWORK ---------------------------------------
$participation->not_user_id = $_SESSION['user_id'];
$output_ties = $participation->selRelations($output_identity_relation['identity_id']);


$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

if (!empty($output_ties)) {
	// we include all module files which have a function to obtain a single item
	// module_id 1 will include a function called -selItemModule1
	if (!empty($core_config['module'])) {
		foreach($core_config['module'] as $key => $i):
			$suffix = $core_config['module'][$key]['prefix'];
			
		    if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
		    	include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
		    }
		endforeach;
	}
	
	
	// get their identities
	foreach ($output_ties as $key => $i):
		$user->identity_ids[] = $i['identity_id_relation'];
		
		// is the relationship mutual?
		$tie->module_id = $i['module_id'];
		$tie->item_id = $i['item_id'];
		
		$output_ties[$key]['common_ties'] = $tie->selCommonTies($i['identity_id_relation'], $i['identity_id']);
		$output_ties[$key]['is_mutual'] = $tie->isMutual($i['identity_id_relation'], $i['identity_id']);
		
		
		$suffix = $core_config['module'][$i['module_id']]['prefix'];
		$function_name = "selItemModule_" . $suffix;
		
		if (function_exists($function_name)) {
			$output_ties[$key]['item'] = $function_name($i['item_id']);
		}
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_identities = $user->selUserIdentities();
		
		// we place the identities against the ties
		if (!empty($output_identities)) {
			foreach ($output_ties as $keyp => $p):
				foreach ($output_identities as $keyi => $i):
					if ($p['identity_id_relation'] == $i['identity_id']) {
						$output_ties[$keyp]['identity'] = $i;
						break;
					}
				endforeach;
			endforeach;
		}
		
		$body->set('ties', $output_ties);
	}
}




/*
// GET TIES -------------------------------------------------------------
require_once ("components/core/class/Tie.class.php");
$tie = new Tie($db, $core_config);
$tie->count_weak = true;
$tie->count_strong = true;
$output_ties['strong'] = $tie->selStrongTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'outbound', 3);
$output_ties['strong_weak'] = $tie->selStrongToWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 3);
$output_ties['weak_strong'] = $tie->selWeakToStrongTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 3);
$output_ties['weak_outbound'] = $tie->selWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'outbound', 3);
$output_ties['weak_inbound'] = $tie->selWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'inbound', 3);

$output_ties_common = $tie->selCommonTies($output_identity['identity_id'], $output_identity_relation['identity_id']);


if (!empty($output_ties)) {
	$body->set('ties', $output_ties);
}

if (!empty($output_ties_common)) {
	$body->set('ties_common', $output_ties_common);
}
*/

require_once ("components/core/class/Testimonial.class.php");
$testimonial = new Testimonial($db);
$testimonial->identity_id = $output_identity_relation['identity_id'];
$testimonial->testifier_identity_id = $output_identity['identity_id'];

$output_testimonials = $testimonial->selTestimonials(true, 2, true);

if (isset($output_testimonials)) {
	$body->set('testimonials', $output_testimonials);
}

// count testimonials
$output_identity_relation['testimonial_count'] = $testimonial->countTestimonials();





$body->set('identity', $output_identity_relation);





// GET THE INVITEE
if (!empty($output_identity_relation['invitee_user_id'])) {
	
	$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
	$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
	
	$output_invitee_identity = $user->selUserIdentity($output_identity_relation['invitee_user_id']);
	
	// get the invitee testimonial
	if (!empty($output_invitee_identity)) {
		$testimonial->user_id = $output_invitee_identity['user_id'];
		$output_testimonial = $testimonial->selTestimonials(false, 1);
		
		if (!empty($output_testimonial[0])) {
			$output_invitee_identity['testimonial'] = $output_testimonial[0];
		}
		
		$body->set('invitee_identity', $output_invitee_identity);
	}
}



// get metadata
$query = "
	SELECT identity_metadata 
	FROM " . $db->prefix . "_user_identity 
	WHERE 
	identity_id=" . $output_identity_relation['identity_id'] . " AND 
	identity_search=1"
;
			
$result = $db->Execute($query);
			
if (isset($result->fields)) {
	if (!empty($result->fields['identity_metadata'])) {
		$identity_metadata = explode(',', $result->fields['identity_metadata']);
		sort($identity_metadata);
		$body->set('identity_metadata', $identity_metadata);
	}
}


// blocked ---------------------------------------
$user->user_id = $_SESSION['user_id'];

if ($user->checkBlockStatus($output_identity_relation['user_id'])) {
	$output_identity_relation['blocking'] = 1;
}


// GET AND SET TAGS ---------------------------------------------
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, null, $core_config['tag']['core']['network']);
$tag->user_id = $_SESSION['user_id'];
$tag->item_id = $output_identity_relation['user_id'];

if (isset($_POST['insert_tag'])) {
	if (empty($_POST['tag_id'])) { // we insert
		$tag->insertTag($_POST['tag_body']);
	}
	elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
		$tag->deleteTag($_POST['tag_id']);
	}
	else { // we update tag
		$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
	}
}
elseif (isset($_POST['delete_tag'])) {
	$tag->deleteTag($_POST['tag_id']);
}
elseif (isset($_REQUEST['edit_tag'])) {
	$output_tag = $tag->selTag($_REQUEST['edit_tag']);

	if (!empty($output_tag)) {
		$body->set('tag', $output_tag);
	}
}

$output_tags = $tag->selTags();

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}



if (is_file($language_path . "/inc/profile.lang.inc.php")) {
	include_once ($language_path . "/inc/profile.lang.inc.php");
}



$body->set('identity', $output_identity_relation);


	
// MODULE FOOTER INCLUSION -----------------------------------------------
// We include any footer files for the modules
if(is_file("components/" . $suffix . "/inc/" . $suffix . "_profile.footer.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_profile.footer.php");
}

?>