<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('blog', 'add_blog', $_SESSION['connection_permission'])) {

	include_once($language_path . 'common.lang.php');
	
	if (isset($_POST['update_blog'])) {
		if (empty($_POST['blog_title'])) {
			$GLOBALS['am_error_log'][] = array('title_empty');
		}

		if (empty($_POST['blog_body'])) {
			$GLOBALS['am_error_log'][] = array('body_empty');
		}

		if (empty($GLOBALS['am_error_log'])) {
			$_POST['blog_title'] = strip_tags($_POST['blog_title']);
		
			$_POST['blog_body'] = am_parse($_POST['blog_body']);
		
			if (!empty($_POST['blog_id'])) { // we update the page
			
				$query = "
					UPDATE " . $db->prefix . "_plugin_blog
					SET
					blog_title=" . $db->qstr($_POST['blog_title']) . ",
					blog_body=" . $db->qstr($_POST['blog_body']) . ",
					blog_edit_datetime=" . $db->qstr(date('Y-m-d H:i:s'))
				;
	
				if (!empty($_REQUEST['wp'])) {
					$query .= ", webpage_id=" . $_REQUEST['wp'];
				}
	
				$query .= "
					WHERE
					blog_id=" . $_POST['blog_id']
				;
				
				$result = $db->Execute($query);
	
				$_SESSION['am_message_log'][] = array($lang['message']['blog_saved']);
				
			}
			else { // we insert
		
				$rec = array();
				$rec['webspace_id'] = $_SESSION['webspace_id'];
				$rec['blog_title'] = $_POST['blog_title'];
				$rec['blog_body'] = $_POST['blog_body'];
				$rec['connection_id'] = $_SESSION['connection_id'];
				$rec['blog_create_datetime'] = time();
	
				if (!empty($_REQUEST['wp'])) {
					$rec['webpage_id'] = $_REQUEST['wp'];
				}
				
				$table = $db->prefix . "_plugin_blog";
				
				$db->insertDb($rec, $table);
		
				$_REQUEST['blog_id'] = $db->insertID();
	
				$_SESSION['am_message_log'][] = array($lang['message']['blog_saved']);
			}
		}
		else {
			$_POST['blog_body'] = stripslashes($_POST['blog_body']);
			$_POST['blog_title'] = htmlspecialchars($_POST['blog_title']);
			$_POST['blog_title'] = stripslashes($_POST['blog_title']);
			
			$body->set('blog', $_POST);
			unset($_REQUEST['blog_id']);
		}
	}
	
	if (isset($_REQUEST['blog_id'])) { // we are editing a page
		$query = "
			SELECT *
			FROM " . $db->prefix . "_plugin_blog
			WHERE blog_id=" . $_REQUEST['blog_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$output_blog = $result[0];
			
			$output_blog['blog_body'] = am_render($output_blog['blog_body']);
			
			$body->set('blog', $output_blog);
		}
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type LIKE 'image/%'"
	;
	
	$output_images = $db->Execute($query);
	if (!empty($output_images)) {
		$body->set('images', $output_images);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type NOT LIKE 'image/%'"
	;
	
	$output_files = $db->Execute($query);
	if (!empty($output_files)) {
		$body->set('files', $output_files);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_webpage
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$output_pages = $db->Execute($query);
	if (!empty($output_pages)) {
		$body->set('pages', $output_pages);
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
?>