<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if (isset($_SESSION['connection_id'])) {
	require_once($language_path . 'network.lang.php');
	
	if (isset($_POST['invite']) && !empty($_POST['invite_open_id'])) {
		// check they have not already been invited
		$query = "
			SELECT connection_id
			FROM " . $db->prefix . "_connection
			WHERE
			connection_openid=" . $db->qstr($_POST['invite_open_id']) . " AND
			webspace_id=" . $_SESSION['webspace_id']
		;
		
		$result = $db->Execute($query);
	
		if (empty($result)) {
			// we apply some checks to the open_id
			$openid = $_POST['invite_open_id'];
			$openid = trim($openid);
	
			if(substr($openid,-1,1) == '/') {
				$openid = substr($openid, 0, strlen($openid)-1);
			}
	
			if(strpos($openid, 'http://') === false) {
				$openid = 'http://'.$openid;
			}
			
			$rec = array();
			$rec['connection_nickname'] = $_POST['invite_nickname'];
			$rec['webspace_id'] = $_SESSION['webspace_id'];
			$rec['connection_create_datetime'] = time();
			$rec['status_id'] = $core_config['connection']['status']['active'];
			$rec['connection_openid'] = $openid;
			$rec['invitee_connection_id'] = $_SESSION['connection_id'];
			
			$table = $db->prefix . "_connection";
				
			$db->insertDb($rec, $table);
		
			$body->set('invited', $rec);
		
			// swap out webspace and nickname in display string
			$lang['txt_invited_connection'] = str_replace('SYS_KEYWORD_NAME', $rec['connection_nickname'], $lang['txt_invited_connection']);
			$lang['txt_invited_connection'] = str_replace('SYS_KEYWORD_URL', $_SERVER['HTTP_HOST'], $lang['txt_invited_connection']);
		}
	}
	
	$query = "
		SELECT connection_id, connection_openid, connection_nickname, connection_email,
		connection_fullname, connection_country, connection_language,
		UNIX_TIMESTAMP(connection_create_datetime) as connection_create_datetime,
		UNIX_TIMESTAMP(connection_last_datetime) as connection_last_datetime,
		status_id, connection_permission, invitee_connection_id 
		FROM " . $db->prefix . "_connection
		WHERE webspace_id=" . $output_webspace['webspace_id']
	;
	
	if (isset($_REQUEST['invited'])) {
		$query .=" AND connection_last_datetime IS NULL";
	}
	else {
		$query .=" AND connection_last_datetime IS NOT NULL";
	}
	
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$output_connections = $result;
	
		if (!empty($output_connections)) {
			$body->set('connections', $output_connections);
		}
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}

?>