<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------
?>

<span id="rating_box_content" class="rating">
<a href="#" id="rate_option1" onMouseOver="javascript:displayRating(1);" onMouseOut="javascript:setRating();" onClick="javascript:submitRating(1);">1</a> <a href="#" id="rate_option2" onMouseOver="javascript:displayRating(2);" onMouseOut="javascript:setRating();" onClick="javascript:submitRating(2);">2</a> <a href="#" id="rate_option3" onMouseOver="javascript:displayRating(3);" onMouseOut="javascript:setRating();" onClick="javascript:submitRating(3);">3</a> <a href="#" id="rate_option4" onMouseOver="javascript:displayRating(4);" onMouseOut="javascript:setRating();" onClick="javascript:submitRating(4);">4</a> <a href="#" id="rate_option5" onMouseOver="javascript:displayRating(5);" onMouseOut="javascript:setRating();" onClick="javascript:submitRating(5);">5</a>
</span>

<script type="text/javascript" language="javascript">
//<![CDATA[
var plugin_item_id = <?php echo $rate_item_id;?>;
var plugin_name = '<?php echo $plugin_name;?>';

var connected = false;
<?php
if (isset($_SESSION['connection_id'])) {
?>
var connected = true;
<?php }?>

var voted = false;

var rate_total;
var rate_votes;
var rate_average;
var rate_vote;


function displayRating (total) {
	
	for (i=1;i<=5;i=i+1) {
		if (i>total) {
			document.getElementById('rate_option'+i).className = 'rating_off';
		}
		else {
			document.getElementById('rate_option'+i).className = 'rating_on';
		}
	}
}

function setRating () {
	total = rate_average;
	
 	for (i=1;i<=5;i=i+1) {
 		document.getElementById('rate_option'+i).className = 'rating_off';
 	}

	for (i=1;i<=total;i=i+1) {
		document.getElementById('rate_option'+i).className = 'rating_on';
	}
}

function submitRating(rating) {
	if (connected ) {
		if (voted) {
			altstr = "This item has received "+rate_votes+" votes totalling "+rate_total+" (average "+rate_average+"). You voted "+rate_vote+".";
			alert(altstr);
		}
		else {
			var str = "plugin_name="+plugin_name+"&plugin_item_id="+plugin_item_id;
		
			if (connected && rating) {
				str += "&rate_value="+rating;
			}
			
			makeRequest('components/core/relay/rate.php', str, receiveRating);
		}
	}
	
	if (!connected && rating) {
		alert ('Please connect to rate this item');
	}
}

function receiveRating() {
	if (http_request.readyState == 4) {
		if (http_request.status == 200) {
			xmlDoc = http_request.responseXML;

			//tst =  http_request.responseText;
			//alert(tst);
			
			if (xmlDoc.getElementsByTagName("total")[0].childNodes[0]) {
				rate_total = xmlDoc.getElementsByTagName("total")[0].childNodes[0].nodeValue;
			}

			if (xmlDoc.getElementsByTagName("votes")[0].childNodes[0]) {
				rate_votes = xmlDoc.getElementsByTagName("votes")[0].childNodes[0].nodeValue;
			}

			if (xmlDoc.getElementsByTagName("average")[0].childNodes[0]) {
				rate_average = xmlDoc.getElementsByTagName("average")[0].childNodes[0].nodeValue;
			}
			
			if (xmlDoc.getElementsByTagName("vote")[0].childNodes[0]) {
				rate_vote = xmlDoc.getElementsByTagName("vote")[0].childNodes[0].nodeValue;
			}

			if (rate_vote>0) {
				voted = true;
			}
			
			setRating();
		} else {
		alert('There was a problem with the request.');
		}
	}
}

submitRating();
//]]>
</script>