<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Event
function plugin_event ($attributes=null) {
	
	global $db, $ws, $output_webspace, $body, $core_config;

	// PREPARE BLOCKS --------------------------------------------------------
	if (!isset($attributes['block'])) {
		$attributes['block'] = "events";
	}

	if ($attributes['block'] == "events") { // select multiple events
	
		// paging...
		$query = "
			SELECT COUNT(e.event_id) AS total
			FROM " . $db->prefix . "_plugin_event e "
		;
		
		if (!empty($attributes['webpagename'])) {
			$query .= ", " . $db->prefix . "_webpage wp ";
		}
		
		$query .= "WHERE e.webspace_id=" . $output_webspace['webspace_id'] . " AND
			e.event_archived IS NULL ";

		if (!empty($attributes['webpagename'])) {
			$query .= " AND
				wp.webspace_id=" . $output_webspace['webspace_id'] . " AND
				wp.webpage_id=e.webpage_id AND
				wp.webpage_name=" . $db->qstr($attributes['webpagename'])
			;
		}
		
		$result = $db->Execute($query);
		
		if (isset($result[0]['total'])) {
			$total = $result[0]['total'];
			$body->set('total_nr_of_rows', $total);
		}
		$from = isset($_GET['_frm']) ? (int) $_GET['_frm'] : 0;
		// eo paging... 
	
	
		$query = "
			SELECT e.event_id, e.event_title, e.event_body, e.webpage_id
			FROM " . $db->prefix . "_plugin_event e "
		;

		if (!empty($attributes['webpagename'])) {
			$query .= ", " . $db->prefix . "_webpage wp ";
		}

		$query .= "
			WHERE 
			e.webspace_id=" . $output_webspace['webspace_id'] . " AND
			e.event_archived IS NULL AND "
		;

		if (!empty($attributes['webpagename'])) {
			$query .= "
				wp.webspace_id=" . $output_webspace['webspace_id'] . " AND
				wp.webpage_id=e.webpage_id AND
				wp.webpage_name=" . $db->qstr($attributes['webpagename']) . " AND "
			;
		}
		
		$query .= "1=1 ORDER BY e.event_start_datetime";
		
		if (!isset($attributes['order'])) {
			$query .= " desc";
		}
		
		if (isset($attributes['limit']) && is_numeric($attributes['limit'])) {
			$result = $db->Execute($query, 0, $attributes['limit']);

			$body->set('limit', $attributes['limit']);
		}
		else {
			$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);
		}
		
		if (!empty($result)) {

			$link = "index.php?ws=" . $output_webspace['webspace_id'];

			foreach($result as $key => $i):
				$result[$key]['event_body'] = strip_tags($result[$key]['event_body']);

				if (strlen($result[$key]['event_body']) > 80) {
					$result[$key]['event_body'] = str_replace_dots($result[$key]['event_body'], 80);
				}

				if (isset($interlink_path_new)) {
					$result[$key]['interlink_path_new'] = 1;
				}

				$result[$key]['link'] = $link . "&amp;wp=" . $i['webpage_id'] . "&amp;event_id=" . $i['event_id'];

			endforeach;

			if (!empty($attributes['webpagename'])) {
				$body->set('event_webpagename', $attributes['webpagename']);
			}
		}
		elseif (isset($_SESSION['connection_permission']) && checkPermission('event', 'add_event', $_SESSION['connection_permission']) && !empty($attributes['webpagename'])) {
			// We append the "no events" with a hint on how to add an event
			global $lang;
			
			$url = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;wpn=" . $attributes['webpagename'];

			// check that the page is a valid page name
			$webpage_exists = $ws->selWebPages($attributes['webpagename']);

			if (!isset($webpage_exists[0]['webpage_name'])) {
				// we have a new page
				$url = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;t=admin_webpage&amp;wp=" . $output_webspace['webpage_id'] . "&amp;wpn=" . $attributes['webpagename'];
				$err_display_no_events = "<interlink name=\"" . $attributes['webpagename'] . "\">" . $lang['err_no_webpage'] . "</interlink>";
			}
			else {
				$lang['err_no_events_hint'] = str_replace('SYS_KEYWORD_URL', $url, $lang['err_no_events_hint']);

				$err_display_no_events = $lang['err_no_events'] . " " . $lang['err_no_events_hint'];

				$body->set('event_webpagename', $attributes['webpagename']);
			}
			
		}
		else {
			global $lang;
			
			$err_display_no_events = $lang['err_no_events'];
		}


		// We push the array into a parent array - this is because we may have multiple listings
		// on a single page
		if (empty($result)) {
			$result['error_txt'] = $err_display_no_events;
		}

		$result = array($result);

		if (isset($body->vars['events'][0])) {
			$body->vars['events'] = $result;
		}
 		else {
			$body->set('events', $result);
 		}
		
	}
	elseif ($attributes['block'] == "event") { // select single event
		
		$query = "
			SELECT e.event_id,
			UNIX_TIMESTAMP(e.event_start_datetime) as event_start_datetime,
			UNIX_TIMESTAMP(e.event_end_datetime) as event_end_datetime, e.event_title,
			e.event_body, e.event_venue, 
			c.connection_nickname, c.connection_openid, c.connection_id 
			FROM " . $db->prefix . "_plugin_event e, " . $db->prefix . "_connection c
			WHERE
			e.connection_id=c.connection_id AND
			e.webspace_id=" . $output_webspace['webspace_id'] . " AND
			e.webpage_id=" . $output_webspace['webpage_id'] . " AND "
		;
		
		if (isset($_REQUEST['event_id'])) {
			$query .= "e.event_id=" . $_REQUEST['event_id'];
		}
		else { // if we do not get a event_id we select the latest
			$query .= "e.event_archived IS NULL ORDER BY e.event_start_datetime desc";
		}

		$result = $db->Execute($query);

		if (isset($result[0])) {
			$event = $result[0];

			$_REQUEST['event_id'] = $event['event_id'];
			
			$body->set('event', $event);
		}
	}
}

?>