<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('forum', 'add_forum_subject', $_SESSION['connection_permission'])) {
	
	include_once($language_path . 'common.lang.php');
	
	if (isset($_POST['update_subject'])) {
		if (empty($_POST['subject_title'])) {
			$GLOBALS['am_error_log'][] = array('title_empty');
		}

		if (empty($_POST['subject_body'])) {
			$GLOBALS['am_error_log'][] = array('body_empty');
		}

		if (empty($GLOBALS['am_error_log'])) {
			$_POST['subject_title'] = strip_tags($_POST['subject_title']);

			$_POST['subject_body'] = am_parse($_POST['subject_body']);
		
			if (!empty($_POST['subject_id'])) { // we update the page
				
				$query = "
					UPDATE " . $db->prefix . "_plugin_forum
					SET
					subject_title=" . $db->qstr($_POST['subject_title']) . ",
					subject_body=" . $db->qstr($_POST['subject_body']) . ",
					subject_edit_datetime=" . $db->qstr(date('Y-m-d H:i:s'))
				;
	
				if (!empty($_REQUEST['wp'])) {
					$query .= ", webpage_id=" . $_REQUEST['wp'];
				}
	
				$query .= "
					WHERE
					subject_id=" . $_POST['subject_id']
				;
				
				$result = $db->Execute($query);
	
				$_SESSION['am_message_log'][] = array($lang['message']['subject_saved']);
			}
			else { // we insert
		
				$rec = array();
				$rec['webspace_id'] = $_SESSION['webspace_id'];
				$rec['subject_title'] = $_POST['subject_title'];
				$rec['subject_body'] = $_POST['subject_body'];
				$rec['connection_id'] = $_SESSION['connection_id'];
				$rec['subject_create_datetime'] = time();
	
				if (!empty($_REQUEST['wp'])) {
					$rec['webpage_id'] = $_REQUEST['wp'];
				}
		
				$table = $db->prefix . "_plugin_forum";
				
				$db->insertDb($rec, $table);
		
				$_REQUEST['subject_id'] = $db->insertID();
	
				$_SESSION['am_message_log'][] = array($lang['message']['subject_saved']);
			}
		}
		else {
			$_POST['subject_body'] = stripslashes($_POST['subject_body']);
			$_POST['subject_title'] = htmlspecialchars($_POST['subject_title']);
			$_POST['subject_title'] = stripslashes($_POST['subject_title']);
			
			$body->set('subject', $_POST);
			unset($_REQUEST['subject_id']);
		}
	}
	

	if (isset($_REQUEST['wpn'])) {
		$query = "
			SELECT webpage_id
			FROM " . $db->prefix . "_webpage
			WHERE
			webpage_name=" . $db->qstr($_REQUEST['wpn']) . " AND
			webspace_id=". $db->qstr($_REQUEST['ws'])
		;

		$result = $db->Execute($query);

		if (!empty($result[0]['webpage_id'])) {
			$_REQUEST['wp'] = $result[0]['webpage_id'];
		}
	}
	
	
	if (isset($_REQUEST['subject_id'])) { // we are editing a page
		$query = "
			SELECT *
			FROM " . $db->prefix . "_plugin_forum
			WHERE subject_id=" . $_REQUEST['subject_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$output_subject = $result[0];
			
			$output_subject['subject_body'] = am_render($output_subject['subject_body']);
			
			$body->set('subject', $output_subject);
		}
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type LIKE 'image/%'"
	;
	
	$output_images = $db->Execute($query);
	if (!empty($output_images)) {
		$body->set('images', $output_images);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_SESSION['webspace_id'] . " AND
		file_type NOT LIKE 'image/%'"
	;
	
	$output_files = $db->Execute($query);
	if (!empty($output_files)) {
		$body->set('files', $output_files);
	}
	
	$query = "
		SELECT *
		FROM " . $db->prefix . "_webpage
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$output_pages = $db->Execute($query);
	if (!empty($output_pages)) {
		$body->set('pages', $output_pages);
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
?>