<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

$queries['wiki'] = "
	SELECT AVG(r.rate_value) AS this_rating, COUNT(*) AS this_num_votes, r.webspace_id, r.plugin_name,
	w.webpage_id, w.wikipage_name AS item_title, wr.revision_create_datetime AS item_create_datetime, wr.revision_body AS item_body,
	wr.revision_id AS item_id,
	((" . $avg_num_votes * $avg_rating . ") + (COUNT(*) * AVG(r.rate_value)))/(" . $avg_num_votes . " + COUNT(*))
	AS br 
	FROM am_rate r
	INNER JOIN " . $db->prefix . "_plugin_wiki_page w
	ON r.plugin_item_id=w.wikipage_id
	INNER JOIN " . $db->prefix . "_plugin_wiki_revision wr
	ON w.current_revision_id=wr.revision_id
	WHERE r.webspace_id=" . $_REQUEST['ws'] . " AND r.plugin_name='wiki'"
;

if ($days_ago) {
	$queries['wiki'] .= $days_ago;
}

$queries['wiki'] .= "GROUP BY r.plugin_name, r.plugin_item_id";

function getRatingLink_wiki($item_id, $webpage_id, $webspace_id) {
	return 'index.php?ws=' . $webspace_id . '&amp;wp=' . $webpage_id . '&amp;subject_id=' . $item_id;
}

?>