<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


include ("config/core.config.php");
include ("inc/functions.inc.php");



// START SESSION -----------------------------------------------------------
session_name($core_config['php']['session_name']);
session_start();


if (isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $core_config['group']['designer']) {

	// SETUP STORAGE ---------------------------------------------------------------------------
	require_once('class/Db.class.php');
	$db = new Database($core_config['db']);


	// SETUP TEMPLATE -------------------------------------------
	define("AM_TEMPLATE_PATH", "template/");
	require_once('class/Template.class.php');
	$tpl = new Template();


	// SETUP LANGUAGE ------------------------------------------------------
	$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];

	if (array_key_exists(strtoupper($_SESSION['language_code']), $core_config['language']['localization'])) {
		$locale_code = $core_config['language']['localization'][strtoupper($_SESSION['language_code'])];

		setlocale(LC_ALL, $locale_code);
	}

	define("AM_LANGUAGE_PATH", "language/" . $_SESSION['language_code'] . "/");

	$lang = array();
	include_once(AM_LANGUAGE_PATH . 'common.lang.php');
	include_once(AM_LANGUAGE_PATH . 'stylesheet_editor.lang.php');

	

	// Selects and displays styles
	// If no styles are present then we skip to create a style
	// if no $_REQUEST['style'] we display default style
	if (isset($_POST['save_stylesheet'])) {
		
		if (!empty($_POST['stylesheet_id'])) {
			$query = "
				UPDATE " . $db->prefix . "_stylesheet
				SET 
				stylesheet_name=" . $db->qstr($_POST['stylesheet_name']) . ", 
				stylesheet_body=" . $db->qstr($_POST['stylesheet_body']) . "
				WHERE 
				stylesheet_id=" . $_POST['stylesheet_id']
			;
			
			$result = $db->Execute($query);
	
			$_REQUEST['stylesheet_id'] = $_POST['stylesheet_id'];

		}
		else { // we insert

			$rec = array();
			$rec['stylesheet_name'] = $_POST['stylesheet_name'];
			$rec['stylesheet_body'] = $_POST['stylesheet_body'];
			$rec['webspace_id'] = $_SESSION['webspace_id'];
	
			$table = $db->prefix . "_stylesheet";
		
			$db->insertDb($rec, $table);

			$_REQUEST['stylesheet_id'] = $db->insertID();;
		}

		$tpl->set('update_mother', 1);
	}
	elseif (isset($_POST['set_current_webspace_style'])) {

		$query = "
			UPDATE " . $db->prefix . "_webspace 
			SET
			stylesheet_id=" . $_POST['default_style_id'] . " 
			WHERE
			webspace_id=" . $_SESSION['webspace_id']
		;

		$result = $db->Execute($query);
		
		$tpl->set('update_mother', 1);
	}
	elseif (isset($_POST['delete_webspace_styles'])) {
		if (!empty($_POST['delete_style_ids'])) {
			$query = "
				DELETE FROM " . $db->prefix . "_stylesheet
				WHERE
				stylesheet_id in (" . implode(",", $_POST['delete_style_ids']) . ")"
			;
	
			$result = $db->Execute($query);
		}

		header("Location: stylesheet_editor.php");
		exit;
	}

	// SELECT CURRENT STYLESHEET
	$query = "
		SELECT ss.stylesheet_id, ss.stylesheet_body
		FROM " . $db->prefix . "_stylesheet ss, " . $db->prefix . "_webspace ws 
		WHERE
		ws.stylesheet_id=ss.stylesheet_id AND 
		ws. webspace_id=" . $_SESSION['webspace_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result[0])) {
		$tpl->set('css', $result[0]);
	}
	
	
	// SELECT STYLESHEETS
	$query = "
		SELECT stylesheet_id, webspace_id, stylesheet_name, stylesheet_body 
		FROM " . $db->prefix . "_stylesheet
		WHERE
		webspace_id=" . $_SESSION['webspace_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		// find current CSS and apply style
		foreach ($result as $key => $i):
			if (isset($_REQUEST['stylesheet_id']) && $_REQUEST['stylesheet_id'] == $i['stylesheet_id']) {
				$tpl->set('style', $i);
			}
		endforeach;

		$tpl->set('styles', $result);
	}

	$tpl->set('lang', $lang);

	echo $tpl->fetch(AM_TEMPLATE_PATH . 'stylesheet_editor.tpl.php');
}
else {
	echo '<html><head><body onload="javascript:self.close();">closing...</body></head></html>';
	exit;
}

?>