<?php

// ---------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// --------------------------------------------------------------------

if (isset($_SESSION['connection_id']) && $_SESSION['connection_id'] == AM_OWNER_CONNECTION_ID) {
	// CUSTOMIZE LANGUAGE
	$openid_account = $_SERVER['SERVER_NAME'];
	$lang['txt_identity_intro'] = str_replace('SYS_KEYWORD_OPENID', $openid_account, $lang['txt_identity_intro']);
	
	
	require_once(AM_LANGUAGE_PATH . 'identity_field_options.lang.php');
	
	
	$identity_attributes = $identity->selConnectionAttributes(AM_OWNER_CONNECTION_ID);
	
	if (!empty($identity_attributes)) {
		$body->set('identity_attributes', $identity_attributes);
	}
	
	$body->set('config_identity_attributes', $core_config['identity_attribute']);

	// GATHER STATISTICS
	$output_statistics = array();

	$output_statistics['total_inbound_connections'] = 0;
	
	$query = "SELECT count(connection_id) as total FROM " . $am_core->prefix . "_connection WHERE identity_id=" . AM_IDENTITY_ID;

	$result = $am_core->Execute($query);
	
	if (isset($result[0]['total'])) {
		$output_statistics['total_inbound_connections'] = $result[0]['total'];
	}

	$output_statistics['total_inbound_connections_trusted'] = 0;
	
	$query = "SELECT count(connection_id) as total FROM " . $am_core->prefix . "_connection WHERE connection_trusted=1 AND identity_id=" . AM_IDENTITY_ID;

	$result = $am_core->Execute($query);
	
	if (isset($result[0]['total'])) {
		$output_statistics['total_inbound_connections_trusted'] = $result[0]['total'];
	}

	$output_statistics['total_outbound_connections'] = 0;
	
	$query = "SELECT count(site_id) as total FROM " . $am_core->prefix . "_site WHERE identity_id=" . AM_IDENTITY_ID;

	$result = $am_core->Execute($query);
	
	if (isset($result[0]['total'])) {
		$output_statistics['total_outbound_connections'] = $result[0]['total'];
	}
	
	$output_statistics['total_outbound_connections_trusted'] = 0;
	
	$query = "SELECT count(site_id) as total FROM " . $am_core->prefix . "_site WHERE site_trusted=1 AND identity_id=" . AM_IDENTITY_ID;

	$result = $am_core->Execute($query);
	
	if (isset($result[0]['total'])) {
		$output_statistics['total_outbound_connections_trusted'] = $result[0]['total'];
	}

	// get plugin statistics
	foreach (glob('plugins/*/inc/statistics.inc.php') as $i):
		require($i);
	endforeach;

	$body->set('statistics', $output_statistics);
}
else {
	header("Location: index.php");
	exit;
}

?>