/* The generic help message for ArX

   Copyright 2003 Walter Landry

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA */

#include <iostream>
#include "command_initializer.hpp"
#include "parse_unknown_options.hpp"
#include "arx_error.hpp"

using namespace std;

void generic_help();

int help(list<string> &argument_list, const command &cmd)
{
  while(!argument_list.empty())
    {
      parse_unknown_options(argument_list);
      break;
    }
  if(!argument_list.empty())
    {
      string subcommand=*argument_list.begin();
      
      /* If we've implemented this command in C++, then run its
         help */
      list<command>::iterator
        action=find(cmd_list::Instance().begin(),
                    cmd_list::Instance().end(),subcommand);
      if(action!=cmd_list::Instance().end())
        {
          list<string> new_arguments;
          new_arguments.push_back("-H");
          action->eval(new_arguments);
        }
      else
        throw arx_error("No such command: " + subcommand);
    }
  else
    {
      generic_help();
    }
  return 0;
}

static command_initializer help_init(command("help",
"Print out a generic help message",
"usage: help",
"",help,"Basic",false));

void generic_help()
{
  cout <<
"Invoke a sub-command of arx.\n\
usage: arx command [options] [arguments]\n\
\n\
All commands take the following options:\n\
 -h -H --help                  print a help message specific to that command\n\
 --silent                      no output\n\
 --quiet                       only output errors\n\
 --default-output              default output\n\
 --report                      slightly verbose output\n\
 --verbose                     maximal output\n\
 --                            mark the end of options\n\
\n\
The -- option is useful for explicitly ending the list of options. This\n\
is useful if a filename, for example, might be mistaken for an option.\n\
\n\
In addition, you can specify the following options instead of a command.\n\
\n\
 -V --version                  print version info\n\
 -h --help                     display this help\n\
 -H --help-commands            display a list of subcommands\n";
}
