/* Print out all of the errors from the patches.

  Copyright (C) 2003 Walter Landry
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 dated June, 1991.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include <list>
#include <string>
#include <utility>
#include "Moved_Path.hpp"
#include "Command_Info.hpp"
#include <iostream>
#include "file_attributes.hpp"

using namespace std;

void output_patching_errors(list<pair<string,string> > &move_conflicts,
                            list<pair<string,string> > &patch_conflicts,
                            list<Moved_Path> &missing_moves,
                            list<string> &missing_patches,
                            list<pair<pair<string,file_attributes>,string> >
                            &add_conflicts)
{
  if(Command_Info::verbosity>=quiet)
    {
      if(!move_conflicts.empty())
        {
          cerr << "Move conflicts.  The following is a list of the paths\nand where the originals are. " << endl;
          for(list<pair<string,string> >::iterator i=move_conflicts.begin();
              i!=move_conflicts.end(); ++i)
            {
              cerr << "M\t" << i->first << "\t" << i->second << endl;
            }
        }
      if(!patch_conflicts.empty())
        {
          cerr << "Patch conflicts.  The following is a list of the files and where the originals are." << endl;
          for(list<pair<string,string> >::iterator i=patch_conflicts.begin();
              i!=patch_conflicts.end(); ++i)
            {
              cerr << "C\t" << i->first << "\t" << i->second << endl;
            }
        }
      if(!missing_patches.empty())
        {
          cerr << "The following paths have patches but do not exist." << endl;
          for(list<string>::iterator i=missing_patches.begin();
              i!=missing_patches.end(); ++i)
            {
              cerr << "E\t" << *i << endl;
            }
        }
      if(!missing_moves.empty())
        {
          cerr << "The following paths have renames but do not exist." << endl;
          for(list<Moved_Path>::iterator i=missing_moves.begin();
              i!=missing_moves.end(); ++i)
            {
              cerr << "R\t" << i->initial.string()
                   << "\t" << i->destination.string() << endl;
            }
        }
      if(!add_conflicts.empty())
        {
          cerr << "The following paths were added, but they have the same inventory id as a\npath already in the inventory.  Perhaps you are trying to apply a patch\nthat has already been applied?" << endl;
            for(list<pair<pair<string,file_attributes>,string> >::iterator
                  i=add_conflicts.begin(); i!=add_conflicts.end(); ++i)
              {
                cerr << "A\t" << i->first.first << "\t"
                     << i->first.second.file_path.native_file_string() << "\t" 
                     << i->second << endl;
                if(!i->first.second.properties.empty())
                  {
                    cerr << "\t  properties:" << "\n";
                    for(map<string,string>::iterator
                          prop=i->first.second.properties.begin();
                        prop!=i->first.second.properties.end(); ++prop)
                      cerr << "\t    " << prop->first << "\t" << prop->second;
                  }
              }
        }
    }
}
