#!/bin/bash
# Unattented Savane test install
# Copyright (C) 2007  Sylvain Beucler
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

## SSH issues
export LANG=C

## Base system
aptitude update # we may have modified sources.list in the clean-up phase

# aptitude: Do not treat Recommended packages as dependencies:
echo 'Aptitude::Recommends-Important "false";' >> /etc/apt/apt.conf.d/00aptitude

# GNU logo on startup
aptitude --assume-yes install grub-splashimages 

wget http://ruslug.rutgers.edu/~mcgrof/grub-images/images/working-splashimages/debian-gnu.xpm.gz -P /boot/grub/splashimages/
ln -sf /boot/grub/splashimages/debian-gnu.xpm.gz /boot/grub/splash.xpm.gz
update-grub

# VServer test:
#aptitude --assume-yes install util-vserver
#vserver test build -m debootstrap -- -d etch -m http://10.0.2.2/mirrors/debian
#echo 101 > /etc/vservers/test/context

## Savane
cd /usr/src
aptitude --assume-yes install subversion
svn co svn://svn.sv.gnu.org/administration/trunk savane
cd savane
aptitude --assume-yes install autoconf automake make \
  mysql-client imagemagick gettext rsync
./bootstrap
./configure.sh
make
make install

# Savane frontend
# Skip networking, so it doesn't attach to 127.0.0.1:3306, and thus
# can be used in a chroot when the host already has another mysqld
# running
mkdir -p /etc/mysql/conf.d
cat <<EOF > /etc/mysql/conf.d/skip-networking.cnf
[mysqld]
skip-networking
EOF
aptitude --assume-yes install apache libapache-mod-php4 mysql-server php4-mysql
make database
ln -s /usr/src/savane/frontend/php /var/www/savane
cat <<EOF > /etc/apache/conf.d/savane.conf
<Directory "/var/www/savane/">
  AllowOverride All
</Directory>
EOF
# Remove default homepage
rm /var/www/index.html
invoke-rc.d apache restart

# Savane backend
aptitude --assume-yes install libmailtools-perl libdbd-mysql-perl \
  libxml-writer-perl libfile-find-rule-perl libterm-readkey-perl \
  libdate-calc-perl libstring-random-perl
cat <<'EOF' > /etc/savane/savane.conf.pl
our $sys_dbhost="localhost";
our $sys_dbname="savane";
our $sys_cron_users="yes";
our $sys_cron_groups="yes";
our $sys_homedir="/home";
EOF
cat <<'EOF' > /etc/cron.d/savane
* * * * *      root    sv_groups --cron && sv_users --cron
EOF
mkdir /srv/cvs /srv/svn /srv/git

# Hacking
aptitude install php-elisp
