/*  -*- Mode: Asm -*-  */

/* Copyright (c) 2002, Joerg Wunsch
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

/* $Id: isinfnan.S,v 1.2 2002/12/09 21:48:11 joerg_wunsch Exp $ */

#include "gasava.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, isnan)
          FUNCTION(isnan)

GLOBAL(isnan)
	CPI	r25, 0xFF	; NaN is 0xffc0XXXX
	BRNE	.Lfalse
	CPI	r24, 0xC0
	BRNE	.Lfalse
.Ltrue:
	LDI	r24, 1
	CLR	r25
	RET

	ENDFUNC

	TEXT_SEG(fplib, isinf)
	FUNCTION(isinf)

GLOBAL(isinf)
	ORI	r25, 0x80	; add sign
	AND	r24, r25	; Inf is 0x7fffffff | signbit
	AND	r24, r23
	AND	r24, r22
	INC	r24
	BREQ	.Ltrue
.Lfalse:
	CLR	r24
	CLR	r25
	RET

	ENDFUNC
