## -*- mode: rpm-spec; -*-
##
##
## Copyright (c) 2004  Theodore A. Roth
## All rights reserved.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright
##   notice, this list of conditions and the following disclaimer.
##
## * Redistributions in binary form must reproduce the above copyright
##   notice, this list of conditions and the following disclaimer in
##   the documentation and/or other materials provided with the
##   distribution.
##
## * Neither the name of the copyright holders nor the names of
##   contributors may be used to endorse or promote products derived
##   from this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
## ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
## LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
## CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
## SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
## INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
## CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
## POSSIBILITY OF SUCH DAMAGE.
##
## $Id: avr-libc.spec.in,v 1.11 2004/11/02 16:01:29 troth Exp $
##
## Generated automatically from avr-libc.spec.in by configure.
##

%define libc_version 1.2.6

# We don't want rpm stripping any files
%define __spec_install_post %{nil}

# Don't build the debuginfo rpm
%define debug_package %{nil}

%define _with_docs 1
%{?_without_docs: %define _with_docs 0}

Summary: AVR libc.
Name: avr-libc
Version: %{libc_version}
Release: 1
Copyright: BSD
Group: Avr/Development/Tools
URL: http://savannah.gnu.org/projects/avr-libc
Source0: http://savannah.gnu.org/download/avr-libc/avr-libc-%{version}.tar.gz
Buildroot: /var/tmp/avr-libc-%{version}-root
BuildRequires: gzip avr-gcc >= 3.3
%if %{_with_docs}
BuildRequires: doxygen >= 1.3.4 tetex
%endif
Requires: avr-gcc >= 3.3

%description
Avr-libc is a C library for developing applications for Atmel AVR
microcontrollers.

%if %{_with_docs}
## The avr-libc-docs subpackage
%package docs
Summary: Documentation for avr-libc.
Group: Avr/Documentation
%description docs
Documentation for avr-libc in html, postscript and pdf formats.
%endif

%prep
%setup -q

%build
rm -fr obj-%{_target_platform}
mkdir obj-%{_target_platform}
cd obj-%{_target_platform}

../configure \
%if %{_with_docs}
	--enable-doc \
%endif
	--prefix=%{_prefix} --mandir=%{_mandir} --infodir=%{_infodir}

make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}
cd obj-%{_target_platform}
make prefix=$RPM_BUILD_ROOT%{_prefix} mandir=$RPM_BUILD_ROOT%{_mandir} \
	infodir=$RPM_BUILD_ROOT%{_infodir} install

%if %{_with_docs}
gzip -9 doc/api/*.ps
gzip -9 doc/api/*.pdf
%endif

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc AUTHORS ChangeLog INSTALL LICENSE NEWS README
%doc doc/CHANGES.old doc/ChangeLog doc/INSTALL doc/TODO
%doc doc/avr-libc-reference.html
#%doc doc/examples/*.c doc/examples/*.h doc/examples/*.s doc/examples/prg
%doc doc/examples/demo/Makefile doc/examples/demo/demo.c
%doc doc/examples/demo/demo.fig
%dir %{_prefix}/avr
%dir %{_prefix}/avr/lib
%dir %{_prefix}/avr/lib/avr3
%dir %{_prefix}/avr/lib/avr4
%dir %{_prefix}/avr/lib/avr5
%dir %{_prefix}/avr/include
%dir %{_prefix}/avr/include/avr
%{_prefix}/avr/lib/lib*
%{_prefix}/avr/lib/crt*
%{_prefix}/avr/lib/avr3/lib*
%{_prefix}/avr/lib/avr3/crt*
%{_prefix}/avr/lib/avr4/lib*
%{_prefix}/avr/lib/avr4/crt*
%{_prefix}/avr/lib/avr5/lib*
%{_prefix}/avr/lib/avr5/crt*
%{_prefix}/avr/include/*.h
%{_prefix}/avr/include/avr/*.h

## TRoth/20021013: Argh! Why does the fscking %doc directive remove the doc
## dir? That's absolutely stupid. We install things there _assuming_ they
## will stay there. Rpm should _not_ removing things we've installed, but alas
## it does. Be sure to watch the output when you are building the packages.

%if %{_with_docs}
%files docs
%defattr(-,root,root)
%doc obj-%{_target_platform}/doc/api/avr-libc-user-manual
%doc obj-%{_target_platform}/doc/api/avr-libc-user-manual.ps.gz
%doc obj-%{_target_platform}/doc/api/avr-libc-user-manual.pdf.gz
%endif

%changelog
* Tue Oct 21 2003 Theodore Roth <troth@openavr.org>
- Allow disabling build of docs sub-package with "--without docs".

* Thu Apr 17 2003 Theodore Roth <troth@openavr.org>
- Don't build debuginfo package.
- Don't run post install since it strips binaries.

* Mon Nov 11 2002 Theodore Roth <troth@openavr.org>
- Add --enable-doc to configure command.

* Sun Oct 13 2002 Theodore Roth <troth@openavr.org>
- Drop avr-gcc requirement to >= 3.2.75 to allow building snapshot packages.
- Add docs sub-package for user manual.

* Mon Aug 12 2002 Joerg Wunsch <j.gnu@uriah.heep.sax.de>
- Require avr-gcc >= 3.3.

* Mon Jul 08 2002 Theodore Roth <troth@verinet.com>
- Integrate spec file into build system.

* Fri May 03 2002 Theodore Roth <troth@verinet.com>
- Added patch to fix timer.h for mega128.

* Mon Apr 29 2002 Theodore Roth <troth@verinet.com>
- Added patch to fix headers.
- Fix strncasecmp_P macro in pgmspace.h.

* Wed Mar 27 2002 Theodore Roth <troth@verinet.com>
- Updated avr-gcc dependency to 3.0.4-2.
- Fixed up %files section to work with rh-7.1.

* Mon Mar 17 2002 Theodore Roth <troth@verinet.com>
- Initial spec file.
