## -*- mode: rpm-spec; -*-
##
##
## Copyright (c) 2004  Theodore A. Roth
## All rights reserved.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright
##   notice, this list of conditions and the following disclaimer.
##
## * Redistributions in binary form must reproduce the above copyright
##   notice, this list of conditions and the following disclaimer in
##   the documentation and/or other materials provided with the
##   distribution.
##
## * Neither the name of the copyright holders nor the names of
##   contributors may be used to endorse or promote products derived
##   from this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
## ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
## LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
## CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
## SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
## INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
## CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
## POSSIBILITY OF SUCH DAMAGE.
##
## $Id: avr-libc.spec.in,v 1.14.2.1 2006/01/06 22:33:36 joerg_wunsch Exp $
##
## avr-libc.spec.  Generated from avr-libc.spec.in by configure.
##

%define libc_version 1.4.8

# We don't want rpm stripping any files
%define __spec_install_post %{nil}

# Don't build the debuginfo rpm
%define debug_package %{nil}

%define _with_docs 1
%{?_without_docs: %define _with_docs 0}

Summary: AVR libc.
Name: avr-libc
Version: %{libc_version}
Release: 1
License: BSD
Group: Avr/Development/Tools
URL: http://savannah.gnu.org/projects/avr-libc
Source0: http://savannah.gnu.org/download/avr-libc/avr-libc-%{version}.tar.bz2
Buildroot: /var/tmp/avr-libc-%{version}-root
BuildRequires: gzip avr-gcc >= 3.4.3
%if %{_with_docs}
BuildRequires: doxygen >= 1.4.1 tetex transfig
%endif
Requires: avr-gcc >= 3.4.3

%define ourdocdir %{_defaultdocdir}/%{name}

%description
Avr-libc is a C library for developing applications for Atmel AVR
microcontrollers.

%if %{_with_docs}
## The avr-libc-docs subpackage
%package docs
Summary: Documentation for avr-libc.
Group: Avr/Documentation
%description docs
Documentation for avr-libc in html, postscript and pdf formats.
%endif

%prep
%setup -q

%build
./configure \
%if %{_with_docs}
	--enable-doc --disable-versioned-doc \
%endif
	--host=avr --build=$(./config.guess) \
	--prefix=%{_prefix} --mandir=%{_mandir} --infodir=%{_infodir}
make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}
make prefix=$RPM_BUILD_ROOT%{_prefix} mandir=$RPM_BUILD_ROOT%{_mandir} \
	infodir=$RPM_BUILD_ROOT%{_infodir} install

# Move/copy files to appropriate directory to workaround the fact that the doc
# directive will delete files that are already installed.
%if ! %{_with_docs}
mkdir -p $RPM_BUILD_ROOT%{ourdocdir}
%endif
cp AUTHORS ChangeLog* INSTALL LICENSE NEWS README $RPM_BUILD_ROOT%{ourdocdir}

%if %{_with_docs}
gzip -9 ${RPM_BUILD_ROOT}%{ourdocdir}/man/man3/*.3
%else
## Don't need man script if we aren't installing man pages.
rm ${RPM_BUILD_ROOT}%{_bindir}/avr-man
%endif

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%docdir %{ourdocdir}
%{ourdocdir}/AUTHORS
%{ourdocdir}/ChangeLog*
%{ourdocdir}/INSTALL
%{ourdocdir}/LICENSE
%{ourdocdir}/NEWS
%{ourdocdir}/README
%{ourdocdir}/examples
%dir %{_prefix}/avr
%dir %{_prefix}/avr/lib
%dir %{_prefix}/avr/lib/avr3
%dir %{_prefix}/avr/lib/avr4
%dir %{_prefix}/avr/lib/avr5
%dir %{_prefix}/avr/include
%dir %{_prefix}/avr/include/avr
%dir %{_prefix}/avr/include/compat
%dir %{_prefix}/avr/include/util
%{_prefix}/avr/lib/lib*
%{_prefix}/avr/lib/crt*
%{_prefix}/avr/lib/avr3/lib*
%{_prefix}/avr/lib/avr3/crt*
%{_prefix}/avr/lib/avr4/lib*
%{_prefix}/avr/lib/avr4/crt*
%{_prefix}/avr/lib/avr5/lib*
%{_prefix}/avr/lib/avr5/crt*
%{_prefix}/avr/include/*.h
%{_prefix}/avr/include/avr/*.h
%{_prefix}/avr/include/compat/*.h
%{_prefix}/avr/include/util/*.h

## TRoth/20021013: Argh! Why does the fscking %doc directive remove the doc
## dir? That's absolutely stupid. We install things there _assuming_ they
## will stay there. Rpm should _not_ removing things we've installed, but alas
## it does. Be sure to watch the output when you are building the packages.

%if %{_with_docs}
%files docs
%defattr(-,root,root)
%{_bindir}/avr-man
%doc %{ourdocdir}/avr-libc-user-manual
%doc %{ourdocdir}/avr-libc-user-manual.ps
%doc %{ourdocdir}/avr-libc-user-manual.pdf
%doc %{ourdocdir}/man
%endif

%changelog
* Fri Jan 6 2006 Galen Seitz <galens@seitzassoc.com>
- Dealt with moved examples directory.

* Tue Nov 10 2005 Galen Seitz <galens@seitzassoc.com>
- Updated to work with latest tools and build procedure.

* Tue Oct 21 2003 Theodore Roth <troth@openavr.org>
- Allow disabling build of docs sub-package with "--without docs".

* Thu Apr 17 2003 Theodore Roth <troth@openavr.org>
- Don't build debuginfo package.
- Don't run post install since it strips binaries.

* Mon Nov 11 2002 Theodore Roth <troth@openavr.org>
- Add --enable-doc to configure command.

* Sun Oct 13 2002 Theodore Roth <troth@openavr.org>
- Drop avr-gcc requirement to >= 3.2.75 to allow building snapshot packages.
- Add docs sub-package for user manual.

* Mon Aug 12 2002 Joerg Wunsch <j.gnu@uriah.heep.sax.de>
- Require avr-gcc >= 3.3.

* Mon Jul 08 2002 Theodore Roth <troth@verinet.com>
- Integrate spec file into build system.

* Fri May 03 2002 Theodore Roth <troth@verinet.com>
- Added patch to fix timer.h for mega128.

* Mon Apr 29 2002 Theodore Roth <troth@verinet.com>
- Added patch to fix headers.
- Fix strncasecmp_P macro in pgmspace.h.

* Wed Mar 27 2002 Theodore Roth <troth@verinet.com>
- Updated avr-gcc dependency to 3.0.4-2.
- Fixed up %files section to work with rh-7.1.

* Mon Mar 17 2002 Theodore Roth <troth@verinet.com>
- Initial spec file.
