/*  BSD-License:

Copyright (c) 2007 by Nils Springob, nicai-systems, Germany
Copyright (c) 2010 by Matthias Bunte, Germany

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the authors the name nicai-systems nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*! @file    odometers.c
 *  @brief   Sensing the ticks at the wheelsensors
 *  @author  Matthias Bunte (m_bunte@arcor.de)
 *  @date    2010-03-22
 */

#include <avr/interrupt.h>
#include "iodefs.h"
#include "hal_odometers.h"
#include "odometers.h"

// #define ODOMETERS_CHECK
#undef ODOMETERS_CHECK

#ifdef ODOMETERS_CHECK
 #include "led.h"
 #define On  (1)
 #define Off (0)
#endif


#ifdef __cplusplus
extern "C" {
#endif

// Initialisierungszustand
static uint8_t  Odometers_InitState = 0;

// Speicher fuer die Ticks an den Radsensoren.
// Diese Variablen werden in den IRQs hochgezaehlt, deshalb volatile
volatile static uint8_t Odometers_L_Val;
volatile static uint8_t Odometers_R_Val;

// Initialisierung
void Odometers_Init(void)
{
  // Initialisierung Odometers Hardware (externe Interrupts)
  HAL_ODOMETERS_INIT();
  // Odometerswerte zuruecksetzen
  Odometers_L_Val = 0;
  Odometers_R_Val = 0;
  // Initialisierung ist nun abgeschlossen
  Odometers_InitState = 1;
}

// Initialisierungszustand auslesen
uint8_t Odometers_Initialized(void)
{
  return Odometers_InitState;
}

uint8_t Odometers_Get_L_Val(void)
{
  // Als Ergebnis den Odometers-Wert liefern  
  return Odometers_L_Val;
}

uint8_t Odometers_Get_R_Val(void)
{
  // Als Ergebnis den Odometers-Wert liefern  
  return Odometers_R_Val;
}

// Bei steigender oder fallender Flanke linke Radsensor-Ticks hochzaehlen
ISR(INT0_vect)
{
  Odometers_L_Val++;

#ifdef ODOMETERS_CHECK
  if (Odometers_L_Val & 0x0001)
    led_set(LED_L_YE, On);
  else
    led_set(LED_L_YE, Off);
#endif  
}

// Bei steigender oder fallender Flanke rechte Radsensor-Ticks hochzaehlen
ISR(INT1_vect)
{
  Odometers_R_Val++;

#ifdef ODOMETERS_CHECK
  if (Odometers_R_Val & 0x0001)
    led_set(LED_R_YE, On);
  else
    led_set(LED_R_YE, Off);
#endif

}


#ifdef __cplusplus
} // extern "C"
#endif

