<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
  
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("bootstrap/bootstrap.php");


class Workbench_Logic
{


  static public function getURLs ($use)
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = Workbench_Logic::getActiveWorkbench ();
    $urls = $database_config_user->getWorkbenchURLs ();
    $urls = unserialize ($urls);
    @$urls = $urls [$workbench];
    if (!is_array ($urls)) $urls = array ();
    if (count ($urls) != 15) {
      $urls = array_fill (0, 15, "");
      $urls [0] = "editusfm/index.php";
      $urls [1] = "resource/index.php";
      $urls [2] = "notes/index.php";
    }
    // Process internal URLs.
    if ($use) {
      foreach ($urls as &$url) {
        if ($url == "") continue;
        $parts = pathinfo ($url);
        $dirname = $parts ['dirname'];
        if ($dirname != basename ($dirname)) continue;
        @$extension = substr ($parts ['extension'], 0, 3);
        if ($extension != 'php') continue;
        // Add the prefix.
        $url = "../$url";
      }
    }
    return $urls;
  }


  static public function setURLs ($values)
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = Workbench_Logic::getActiveWorkbench ();
    $urls = $database_config_user->getWorkbenchURLs ();
    $urls = unserialize ($urls);
    $urls [$workbench] = $values;
    $urls = serialize ($urls);
    $database_config_user->setWorkbenchURLs ($urls);
  }
  

  static public function getWidths ()
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = Workbench_Logic::getActiveWorkbench ();
    $widths = $database_config_user->getWorkbenchWidths ();
    $widths = unserialize ($widths);
    @$widths = $widths [$workbench];
    if (!is_array ($widths)) $widths = array ();
    foreach ($widths as $offset => $width) {
      $reset = false;
      if (Filter_Numeric::integer_in_string ($width) != $width) $reset = true;
      if (!is_numeric ($width)) $reset = true;
      if ($reset) $widths [$offset] = 32;
      $reset = false;
    }
    if (count ($widths) != 15) {
      $widths = array_fill (0, 15, 19);
      $widths [0] = 32;
      $widths [1] = 32;
      $widths [2] = 32;
      $widths [3] = 0;
      $widths [4] = 0;
    }
    return $widths;
  }


  public static function setWidths ($values)
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = Workbench_Logic::getActiveWorkbench ();
    $widths = $database_config_user->getWorkbenchWidths ();
    $widths = unserialize ($widths);
    $widths [$workbench] = $values;
    $widths = serialize ($widths);
    $database_config_user->setWorkbenchWidths ($widths);
  }


  static public function getHeights ()
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = Workbench_Logic::getActiveWorkbench ();
    $heights = $database_config_user->getWorkbenchHeights ();
    $heights = unserialize ($heights);
    @$heights = $heights [$workbench];
    if (!is_array ($heights)) $heights = array ();
    $reset = false;
    if (count ($heights) != 3) $reset = true;
    foreach ($heights as $height) {
      if (Filter_Numeric::integer_in_string ($height) != $height) $reset = true;
      if (!is_numeric ($height)) $reset = true;
    }
    if ($reset) {
      $heights = array (80, 0, 0);
    }
    return $heights;
  }
  
  
  public static function setHeights ($values)
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = Workbench_Logic::getActiveWorkbench ();
    $heights = $database_config_user->getWorkbenchHeights ();
    $heights = unserialize ($heights);
    $heights [$workbench] = $values;
    $heights = serialize ($heights);
    $database_config_user->setWorkbenchHeights ($heights);
  }


  public static function getActiveWorkbench ()
  {
    $database_config_user = Database_Config_User::getInstance ();
    $workbench = $database_config_user->getActiveWorkbench ();
    if ($workbench == "") {
      $workbench = "default";
    }
    return $workbench;
  }
  
  
  public static function getWorkbenches ()
  {
    $database_config_user = Database_Config_User::getInstance ();
    $urls = $database_config_user->getWorkbenchURLs ();
    $urls = unserialize ($urls);
    if (!is_array ($urls)) {
      return array (Workbench_Logic::getActiveWorkbench ());
    }
    $workbenches = array_keys ($urls);
    if (count ($workbenches) == 0) {
      return array (Workbench_Logic::getActiveWorkbench ());
    }
    return $workbenches;
  }
  
  
  public static function deleteWorkbench ($offset)
  {
    $workbenches = Workbench_Logic::getWorkbenches ();
    $workbench = $workbenches [$offset];

    $database_config_user = Database_Config_User::getInstance ();

    $urls = $database_config_user->getWorkbenchURLs ();
    $urls = unserialize ($urls);
    unset ($urls [$workbench]);
    $urls = serialize ($urls);
    $database_config_user->setWorkbenchURLs ($urls);

    $widths = $database_config_user->getWorkbenchWidths ();
    $widths = unserialize ($widths);
    unset ($widths [$workbench]);
    $widths = serialize ($widths);
    $database_config_user->setWorkbenchWidths ($widths);

    $heights = $database_config_user->getWorkbenchHeights ();
    $heights = unserialize ($heights);
    unset ($heights [$workbench]);
    $heights = serialize ($heights);
    $database_config_user->setWorkbenchHeights ($heights);
    $database_config_user->setActiveWorkbench ("");
  }
  
  
}


?>
