<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

require_once ("../bootstrap/bootstrap.php");
page_access_level ((Filter_Roles::ADMIN_LEVEL));

Assets_Page::header (gettext ("Collaboration"));

$view = new Assets_View (__FILE__);

$object = $_GET ['object'];
$view->view->object = $object;

$directory = Filter_Git::git_directory ($object);

$database_config_user = Database_Config_User::getInstance();
$url = $database_config_user->getRemoteRepositoryUrl ($object);
$view->view->url = $url;

$ready = false;
$database_shell = Database_Shell::getInstance ();
$output = "";
$contents = array ();
switch ($database_shell->logic ("collaboration_repo_clone", 0, $output)) {
  case 1: 
    $workingdirectory = dirname (__FILE__);
    $object = escapeshellarg ($object);
    $directory = escapeshellarg ($directory);
    shell_exec ("cd $workingdirectory; php collaboration_repo_clone-cli.php $object $directory > $output 2>&1 &");
    break;
  case 0:
    $contents = file ($output, FILE_IGNORE_NEW_LINES);
    break;
  case -1:
    $contents = file ($output, FILE_IGNORE_NEW_LINES);
    $ready = true;
    break;
}
@$view->view->contents = $contents;

$view->render ("collaboration_repo_clone1.php");
if ($ready) $view->render ("collaboration_repo_clone2.php");

Assets_Page::footer ();

?>
