<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Changes
{

  private static $instance;
  private function __construct () {
  } 
  public static function getInstance () 
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Changes ();
    }
    return self::$instance;
  }


  public function optimize ()
  {
    $database_instance = Database_Instance::getInstance();
    $database_instance->runQuery ("REPAIR TABLE changes;");
    $database_instance->runQuery ("OPTIMIZE TABLE changes;");
  }


  public function trim ()
  {
    $database_instance = Database_Instance::getInstance();
    $time = time () - 7776000; // Remove entries after 90 days.
    $query = "DELETE FROM changes WHERE timestamp < $time;";
    $database_instance->runQuery ($query);
  }   


  public function record ($users, $category, $bible, $book, $chapter, $verse, $oldtext, $modification, $newtext)
  {
    $bible = Database_SQLInjection::no ($bible);
    $category = Database_SQLInjection::no ($category);
    $book = Database_SQLInjection::no ($book);
    $chapter = Database_SQLInjection::no ($chapter);
    if ($verse == "") $verse = 0;
    $verse = Database_SQLInjection::no ($verse);
    $oldtext = Database_SQLInjection::no ($oldtext);
    $modification = Database_SQLInjection::no ($modification);
    $newtext = Database_SQLInjection::no ($newtext);
    $database_instance = Database_Instance::getInstance();
    // Normally this function is called just after midnight.
    // It would then put the current time on changes made the day before.
    // Make a correction for that by subtracting 6 hours.
    $timestamp = time () - 21600;
    foreach ($users as $user) {
      $user = Database_SQLInjection::no ($user);
      $query = "INSERT INTO changes VALUES (NULL, $timestamp, '$user', '$category', $bible, $book, $chapter, $verse, '$oldtext', '$modification', '$newtext');";
      $result = $database_instance->runQuery ($query);
    }
  }


  public function getIdentifiers ($username = "")
  {
    $query = "SELECT id FROM changes ";
    if ($username != "") {
      $username = Database_SQLInjection::no ($username);
      $query .= " WHERE username = '$username' ";
    }
    // Sort on reference, so that related changes are near each other.
    $query .= " ORDER BY book ASC, chapter ASC, verse ASC, id ASC;";
    $database_instance = Database_Instance::getInstance();
    $result = $database_instance->runQuery ($query);
    $ids = array ();
    for ($i = 0; $i < $result->num_rows; $i++) {
      $row = $result->fetch_row ();
      $ids [] = $row [0];
    }
    return $ids;
  }


  // This gets the identifiers of the personal change proposals.
  // For easier comparison, it also gets the identifiers of the changes 
  // in the verses that have personal change proposals.
  public function getPersonalIdentifiers ($username, $category)
  {
    $username = Database_SQLInjection::no ($username);
    $database_instance = Database_Instance::getInstance();
    
    // Get all personal change proposals.
    $personalIDs = array ();
    $query = "SELECT id FROM changes WHERE username = '$username' AND category = '$category' ORDER BY book ASC, chapter ASC, verse ASC, id ASC;";
    $database_instance = Database_Instance::getInstance();
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $row = $result->fetch_row ();
      $personalIDs [] = $row [0];
    }

    $allIDs = array ();

    // Go through each of the personal change proposals.
    foreach ($personalIDs as $personalID) {
      // Add the personal change proposal to the results.
      $allIDs [] = $personalID;
      // Get the Bible and passage for this change proposal.
      $bibleID = $this->getBible ($personalID);
      $passage = $this->getPassage ($personalID);
      $book = $passage ['book'];
      $chapter = $passage ['chapter'];
      $verse = $passage ['verse'];
      // Look for change proposals for this Bible and passage.
      $query = "SELECT id FROM changes WHERE username = '$username' AND bible = $bibleID AND book = $book AND chapter = $chapter AND verse = $verse ORDER BY id ASC;";
      $result = $database_instance->runQuery ($query);
      for ($i = 0; $i < $result->num_rows; $i++) {
        $row = $result->fetch_row ();
        $id = $row [0];
        // Add the identifier if it's not yet in.
        if (!in_array ($id, $allIDs)) {
          $allIDs [] = $id;
        }
      }
    }
    
    

    return $allIDs;
  }


  // This gets the identifiers of the team's changes.
  public function getTeamIdentifiers ($username, $category)
  {
    $username = Database_SQLInjection::no ($username);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT id FROM changes WHERE username = '$username' AND category = '$category' ORDER BY book ASC, chapter ASC, verse ASC, id ASC;";
    $result = $database_instance->runQuery ($query);
    $ids = array ();
    for ($i = 0; $i < $result->num_rows; $i++) {
      $row = $result->fetch_row ();
      $ids [] = $row [0];
    }
    return $ids;
  }


  public function delete ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "DELETE FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
  }


  public function getTimeStamp ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT timestamp FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $timestamp = $result->fetch_row ();
      $timestamp = $timestamp [0];
      return $timestamp;
    }
    return time ();
  }


  public function getCategory ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT category FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $category = $result->fetch_row ();
      $category = $category [0];
      return $category;
    }
    return NULL;
  }


  public function getBible ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT bible FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $bible = $result->fetch_row ();
      $bible = $bible [0];
      return $bible;
    }
    return 0;
  }


  public function getPassage ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT book, chapter, verse FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      return $result->fetch_assoc ();
    }
    return NULL;
  }


  public function getOldText ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT oldtext FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $old_text = $result->fetch_row ();
      $old_text = $old_text [0];
      return $old_text;
    }
    return "";
  }


  public function getModification ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT modification FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $modification = $result->fetch_row ();
      $modification = $modification [0];
      return $modification;
    }
    return NULL;
  }


  public function getNewText ($id)
  {
    $id = Database_SQLInjection::no ($id);
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT newtext FROM changes WHERE id = $id;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $new_text = $result->fetch_row ();
      $new_text = $new_text [0];
      return $new_text;
    }
    return "";
  }


  public function clearUser ($username)
  {
    $username = Database_SQLInjection::no ($username);
    $database_instance = Database_Instance::getInstance();
    $query = "DELETE FROM changes WHERE username = '$username';";
    $result = $database_instance->runQuery ($query);
  }
  

  // This function deletes personal change proposals and their matching change notifications.
  public function clearMatches ($username, $personal, $team)
  {
    // Clean input.
    $personal = Database_SQLInjection::no ($personal);
    $team = Database_SQLInjection::no ($team);

    $database_instance = Database_Instance::getInstance();

    // Select all identifiers of the personal change proposals.
    $query = "SELECT id, bible, book, chapter, verse, modification FROM changes WHERE username = '$username' AND category = '$personal';";
    $result = $database_instance->runQuery ($query);
    $rows = array ();
    for ($i = 0; $i < $result->num_rows; $i++) {
      $row = $result->fetch_assoc ();
      $rows [] = $row;
    }
    unset ($row);
    
    // Matches to be deleted.
    $deletes = array ();

    // Get all matching identifiers among the team's change notifications.
    foreach ($rows as $row) {
      $id = $row ['id'];
      $bible = $row ['bible'];
      $book = $row ['book'];
      $chapter = $row ['chapter'];
      $verse = $row ['verse'];
      $modification = $row ['modification'];
      $modification = Database_SQLInjection::no ($modification);
      $query = "SELECT id FROM changes WHERE username = '$username' AND category = '$team' AND bible = $bible AND book = $book AND chapter = $chapter AND verse = $verse AND modification = '$modification';";
      $result = $database_instance->runQuery ($query);
      // There should be exactly one result for the matches to be removed.
      // If there is only one, it means there's no matching change to the change proposal.
      // If there are two or more matching changes, then one could have undone the other.
      if ($result->num_rows == 1) {
        for ($i = 0; $i < $result->num_rows; $i++) {
          $row = $result->fetch_assoc ();
          $id2 = $row ['id'];
          // Check there are only two change notifications for this user / Bible / book / chapter / verse.
          // If there are more, we can't be sure that the personal change proposal was not overwritten somehow.
          $query = "SELECT id FROM changes WHERE username = '$username' AND bible = $bible AND book = $book AND chapter = $chapter AND verse = $verse;";
          $result = $database_instance->runQuery ($query);
          if ($result->num_rows == 2) {
            // Store the personal change proposal to be deleted.
            $deletes [] = $id;
            // Store the matching change notification to be deleted also.
            $deletes [] = $id2;
          }
        }
      }
    }
    
    // Delete all stored identifiers to be deleted.
    foreach ($deletes as $delete) {
      $query = "DELETE FROM changes WHERE id = $delete;";
      $database_instance->runQuery ($query);
    }
  }


}



?>
