<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


// Database resilience.
// It does not contain important information.
// Re-create it if corrupted.

class Database_Ipc
{
  private static $instance;
  private $db;
  private function __construct() {
    $this->db = Database_SQLite::connect ("ipc");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Ipc();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS ipc (
  user text,
  channel text,
  command text,
  message text
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
  }


  public function trim ()
  {
    $query = "DELETE FROM ipc WHERE user = '';";
    Database_SQLite::exec ($this->db, $query);
  }


  public function optimize ()
  {
    Database_SQLite::exec ($this->db, "VACUUM ipc;");
  }


  public function storeMessage ($user, $channel, $command, $message)
  {
    $user    = Database_SQLiteInjection::no ($user);
    $channel = Database_SQLiteInjection::no ($channel);
    $command = Database_SQLiteInjection::no ($command);
    $message = Database_SQLiteInjection::no ($message);
    if ($channel == "") {
      $query = "DELETE FROM ipc WHERE user = '$user' AND channel = '' AND command = '$command';";
      Database_SQLite::exec ($this->db, $query);
    }
    $query = "INSERT INTO ipc VALUES ('$user', '$channel', '$command', '$message');";
    Database_SQLite::exec ($this->db, $query);
  }


  /**
  * Retrieves a message if there is any.
  * Returns NULL if there was nothing,
  * else an associated array with keys and values for "id", "channel", "command" and "message".
  */
  public function retrieveMessage ($id, $user, $channel, $command)
  {
    $id = Database_SQLiteInjection::no ($id);
    $channel = Database_SQLiteInjection::no ($channel);
    $command = Database_SQLiteInjection::no ($command);
    $query = "SELECT rowid, channel, command, message FROM ipc WHERE rowid > $id AND (channel = '$channel' OR channel = '') AND (user = '$user' OR user = '') AND command = '$command' ORDER BY rowid DESC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $row ['id'] = $row ['rowid'];
      unset ($row ['rowid']);
      unset ($row[0]);
      unset ($row[1]);
      unset ($row[2]);
      unset ($row[3]);
      return $row;
    }
    return NULL;
  }


  public function deleteMessage ($id)
  {
    $id = Database_SQLiteInjection::no ($id);
    $query = "DELETE FROM ipc WHERE rowid = $id;";
    Database_SQLite::exec ($this->db, $query);
  }


  public function getFocus ()
  {
    $session_logic = Session_Logic::getInstance ();
    $user = $session_logic->currentUser ();
    $user = Database_SQLiteInjection::no ($user);
    $message = array ();
    $query = "SELECT message FROM ipc WHERE command = 'focus' AND user = '$user' ORDER BY rowid DESC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    // No focus found: Return Genesis 1:1.
    return "1.1.1";
  }


  public function getNote ()
  {
    $session_logic = Session_Logic::getInstance ();
    $user = $session_logic->currentUser ();
    $user = Database_SQLiteInjection::no ($user);
    $query = "SELECT rowid, message FROM ipc WHERE user = '$user' AND command = 'opennote' ORDER BY rowid DESC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $row ['id'] = $row ['rowid'];
      unset ($row [0]);
      unset ($row [1]);
      return $row;
    }
    return NULL;
  }


  public function getNotesAlive ()
  {
    $session_logic = Session_Logic::getInstance ();
    $user = $session_logic->currentUser ();
    $user = Database_SQLiteInjection::no ($user);
    $query = "SELECT message FROM ipc WHERE user = '$user' AND command = 'notesalive' ORDER BY rowid DESC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row[0];
    }
    return false;
  }


  public function getBibleAlive ()
  {
    $session_logic = Session_Logic::getInstance ();
    $user = $session_logic->currentUser ();
    $user = Database_SQLiteInjection::no ($user);
    $query = "SELECT message FROM ipc WHERE user = '$user' AND command = 'biblealive' ORDER BY rowid DESC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row[0];
    }
    return false;
  }


  public function debug ()
  {
    $result = Database_SQLite::query ($this->db, "SELECT rowid, * from ipc;");
    foreach ($result as $row) {
      for ($i = 0; $i <= 4; $i++) unset ($row[$i]);
      var_dump ($row);
    }
  }


}



?>
