<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");


$database_logs = Database_Logs::getInstance ();


// Security: The script runs from the cli SAPI only.
if (php_sapi_name () != "cli") {
  $database_logs->log ("reindex: Fatal: This only runs through the cli Server API", Filter_Roles::ADMIN_LEVEL);
  die;
}


// It is necessary to rebuild the notes index completely, because 
// it could have happened that certain values at certain times could not be written
// to the database because of errors. Then the notes index would not match the notes data.
$database_logs->log ("Rebuilding Consultation Notes index", Filter_Roles::MANAGER_LEVEL);
$database_notes = Database_Notes::getInstance ();
$database_notes->rebuild ();
$database_logs->log ("Rebuilding Consultation Notes index ready", Filter_Roles::MANAGER_LEVEL);


?>
